class Balloon
{
  //variables
  PVector balloonPos = new PVector ();

  Balloon ()
  {
    //set bloon's initial position to the middle of the window
    balloonPos.x = width/2;
    balloonPos.y = height/2;
  }

  void goBalloon()
  { 
    //restrict bloon from going off screen 
    //ex. if the A key is pressed and the balloonPos.x is greater than 0,
    //    then the bloon can move left.

    if (goLeft == true && balloonPos.x > 0) {
      balloonPos.x = balloonPos.x - 1;
    } else if (goRight == true && balloonPos.x < width) {
      balloonPos.x = balloonPos.x + 1;
    } else if (goUp == true && balloonPos.y > 0) {
      balloonPos.y = balloonPos.y - 1;
    } else if (goDown == true && balloonPos.y < height) {
      balloonPos.y = balloonPos.y + 1;
    }
  }

  //constructor: draw a hot air balloon.
  void display()
  {
    ellipseMode(CENTER);
    rectMode(CENTER);

    //draw ropes
    stroke(#CB9E79);
    strokeWeight(2);
    line(balloonPos.x-15, balloonPos.y, balloonPos.x-10, balloonPos.y+50);
    line(balloonPos.x+15, balloonPos.y, balloonPos.x+10, balloonPos.y+50);

    noStroke();

    //draw bloon part
    fill(#FFE68B);
    ellipse(balloonPos.x, balloonPos.y, 60, 60);
    fill(#FFA052);
    ellipse(balloonPos.x, balloonPos.y, 40, 60);

    //draw basket part
    fill(#CB9E79);
    rect(balloonPos.x, balloonPos.y+60, 20, 20);
  }
}