/* - - - - - - - - - - - - - - - - - - - - - - - /
 SHARKS WITH JETPACKS
 by A.Bellikka
 Submitted October 23, 2016
 
 control the hot air balloon with WASD
 try to avoid sharks! chomp
 - - - - - - - - - - - - - - - - - - - - - - - - */

/*
-REFERENCES:
(N.Hesler, "Gone Fishing", n.d.) -- shark movement/code layout
(A.Bellikka, "Gameboy", 2016) -- balloon movement
(M.Arcadi, "SNEK", 2015) -- keyPressed conditionals
*/

//global variables
Balloon bloon;
JetShark shark;

//make only four sharks appear on the screen at one time
int sharkLimit = 4;
JetShark[] schoolOfSharks = new JetShark[sharkLimit];

// W A S D bools
boolean goUp = false;
boolean goDown = false;
boolean goLeft = false;
boolean goRight = false;


void setup()
{
  size(400, 400);
  frameRate(120);

  //call game objects
  bloon = new Balloon();
  createSharks();
}
void createSharks()
{
  for (int i = 0; i<schoolOfSharks.length; i++) {
    schoolOfSharks[i] = new JetShark();
  }
}

void draw()
{
  //sky blue
  background(#008aff);

  //call sky visuals
  drawClouds();
  drawGradientLoop();

  //call bloon-related functions
  keyPressed();
  bloon.display();
  bloon.goBalloon();

  //call shark-related functions
  //reference N.Hesler
  for (int i=0; i<schoolOfSharks.length; i++) {
    schoolOfSharks[i].moveSharks();

    for (int u=0; u<schoolOfSharks.length; u++) {
      schoolOfSharks[u].display();
    }
  }
}

void drawClouds()
{
  rectMode(CORNERS);

  fill(255);
  noStroke();

  //make the clouds "drift" side to side slowly
  rect(60+sin(frameCount*0.015)*7, 40, 160+sin(frameCount*0.015)*7, 100, 25);
  rect(140+sin(frameCount*0.015)*7, 60, 200+sin(frameCount*0.015)*7, 100, 25);

  rect(200+sin(frameCount*0.015)*7, 20, 240+sin(frameCount*0.015)*7, 40, 25);

  rect(260+sin(frameCount*0.015)*7, 60, 290+sin(frameCount*0.015)*7, 80, 25);
  rect(280+sin(frameCount*0.015)*7, 50, 330+sin(frameCount*0.015)*7, 80, 25);

  rect(180+sin(frameCount*0.015)*7, 220, 210+sin(frameCount*0.015)*7, 240, 25);
  rect(220+sin(frameCount*0.015)*7, 180, 320+sin(frameCount*0.015)*7, 240, 25);
  rect(300+sin(frameCount*0.015)*7, 210, 330+sin(frameCount*0.015)*7, 240, 25);

  rect(310+sin(frameCount*0.015)*7, 250, 350+sin(frameCount*0.015)*7, 270, 25);

  rect(-5+sin(frameCount*0.015)*7, 300, 60+sin(frameCount*0.015)*7, 340, 25);
  rect(40+sin(frameCount*0.015)*7, 280, 140+sin(frameCount*0.015)*7, 340, 25);
  rect(150+sin(frameCount*0.015)*7, 320, 180+sin(frameCount*0.015)*7, 340, 25);

  rect(220+sin(frameCount*0.015)*7, 380, 280+sin(frameCount*0.015)*7, 420, 25);
  rect(260+sin(frameCount*0.015)*7, 360, 380+sin(frameCount*0.015)*7, 420, 25);
}

void drawGradientLoop()
{
  rectMode(CENTER);
  noStroke();

  //int c refers to rect transparency
  //make the background have a loop of rectangles that create a gradient
  int y = 0;
  for (int c = 190; c > 0; c -=15)
  {
    fill(255, c);
    rect(width/2, y, width, 30);
    y = y+30;
  }
}

void keyPressed()
{
  //if the w key is pressed, bloon will go up
  if (key == 'w') {   
    goUp=true;
    goDown=false;
    goLeft=false;
    goRight=false;
    //if the a key is pressed, bloon will go left
  } else if (key == 'a') {
    goLeft=true;
    goRight = false;
    goUp = false;
    goDown = false;
    //if the s key is pressed, bloon will go down
  } else if (key == 's') {
    goDown = true;
    goUp = false;
    goLeft = false;
    goRight = false;
    //if the d key is pressed, bloon will go right
  } else if (key == 'd') {
    goRight=true;
    goUp = false;
    goDown = false;
    goLeft = false;
  }
}