class Asteroids {

  float asteroidSize;
  color asteroidColor;

  //position/velocity vector
  PVector position;
  PVector velocity;

  Asteroids() {
    //resets the p when offscreen
    reset();
  }

  void update() {
    position.add(velocity);
    if (position.x<-150) {
      reset();
    }
  }

  void setAsteroidSize() {
    asteroidSize=random(60, 150);
  }

  void setAsteroidColor() {
    asteroidColor=color(random(140, 165), random(140, 165), random(140, 165));
  }

  void display() {
    stroke(0, 50);
    fill(asteroidColor);
    ellipse(position.x, position.y, asteroidSize, asteroidSize);
    noStroke();
  }    

  void reset() {
    //reset the asteroid when it goes 150px offscreen
    position = new PVector (width+200, random(0, height));
    velocity = new PVector (random(-6, -1), random(-1, 1));
    setAsteroidSize();
    setAsteroidColor();
  }
}