//score variables
int scoreFuel;

class Fuel {

  //size variables
  int fuelWide = 35;
  int fuelHeight = 30;

  //position/velocity vector
  PVector position;
  PVector velocity;

  Fuel() {
    //resets the fuel can when it is picked up
    reset();
  }

  void update() {
    position.add(velocity);

    //reset the fuel can if it goes off screen
    if (position.x<-100) {
      reset();
      scoreFuel = scoreFuel - 2;
    }
    
    if (scoreFuel<0) {
      scoreFuel=0;
    }
  }

  void display() {
    //no strokes
    noStroke();
    rectMode(CENTER);
    fill(170, 45, 45);
    rect(position.x, position.y, 30, 35);
    fill(137, 127, 127);
    rect(position.x-5, position.y-20, 15, 5);
    fill(211,182,117);
    rect(position.x, position.y, 20,10);
  }

  //summon new fuel can when it's collected
  void reset() {
    //start at the right of the screen at different heights/velocity
    position = new PVector(width+fuelWide, random(10, height-10));
    velocity = new PVector(random(-5, -2), 0);
  }

  //score
  void collected() {
    if (mousePressed && dist(mouseX, mouseY, position.x, position.y) < fuelWide) {
      reset();
      scoreDisplay();
      scoreFuel += 1;
    }
  }

  void scoreDisplay() {
    fill(255);
    textAlign (LEFT);
    textSize (15);

    text("Fuel Cans:", 20, 30);
    text(scoreFuel, 140, 30);
  }
}