/* //////////////////////////////////////////////////////////////////////////////// */
/*                               ASTEROID AVOID by ANDREEA POP                      */
/* The basic premise of this game is to collect as many fuel cans as you can while  */
/* avoiding the asteroids flying in your direction. NOTE: The collision on the      */
/* asteroids is a bit wonky and the spaceship may clip through an asteroid before   */
/* the hit is detected. The ship will follow your mouse, and clicking the right     */
/* mouse will collect fuel cans. To save your fingers from constant tapping, you    */
/* can simply hold down the mouse. Missing a fuel can will lower your score by 2.   */
/* Hitting an asteroid will restart the game and your score.                        */
/*                                                                                  */
/* Thank you to whoever made these programs, without you I'd still be stumped on    */
/* how to make collisions and crying.                                               */
/*                                                                                  */
/* - http://www-acad.sheridanc.on.ca/PROG14998/2015/oo-toy/oo_toy_33/               */
/* - http://www-acad.sheridanc.on.ca/PROG14998/2015/oo-toy/oo_toy_10/               */
/* //////////////////////////////////////////////////////////////////////////////// */

//Define the objects in the program
Spaceship spaceShip;
ArrayList <Asteroids> asteroidsList;

//arrays - stars
int numberOfStars = 20;
Stars[] spaceStars = new Stars[numberOfStars];

//arrays - fuel
int numberOfFuelCans = 2;
Fuel[] spaceFuel = new Fuel[numberOfFuelCans];

//collision padding, how far from the pos.x/y will collision be detected
int padding = 30;

void setup() {
  //set up window size + frame rate
  size(800, 600);
  frameRate(60);

  //instructions
  println("Hold down the mouse button to collect fuel cans! Missing one will lower your score.");
  println("Avoid the asteroids or they'll reset you.");

  //initilization
  spaceShip = new Spaceship();
  asteroidsList = new ArrayList();

  for (int i=0; i<spaceFuel.length; i+=1) {
    spaceFuel[i] = new Fuel();
  }

  for (int i=0; i<10; i++) {
    Asteroids spaceAsteroids=new Asteroids();
    asteroidsList.add(spaceAsteroids);
  }

  for (int i=0; i<spaceStars.length; i++) {
    spaceStars[i]=new Stars(random(width, width+100), random(0, height), random(-15, -5));
  }
}

void draw() {
  //updates
  for (int i=0; i<spaceStars.length; i++) {
    spaceStars[i].update();
  }
  for (int i=0; i<asteroidsList.size (); i++) {
    asteroidsList.get(i).update();
  }

  for (int i=0; i<spaceFuel.length; i+=1) {
    spaceFuel[i].update();
  }

  //display
  background(0);

  for (int i=0; i<spaceStars.length; i++) {
    spaceStars[i].display();
  }

  for (int i=0; i<asteroidsList.size (); i++) {
    asteroidsList.get(i).display();
  }

  for (int i=0; i<spaceFuel.length; i+=1) {
    spaceFuel[i].display();
    spaceFuel[i].collected();
    spaceFuel[i].scoreDisplay();
  }

  //show the spaceship on screen
  spaceShip.display();
  collision();
}

void collision() {
  for (int i=0; i<asteroidsList.size (); i+=1) {
    if (dist(spaceShip.shipTop.x, spaceShip.shipTop.y, asteroidsList.get(i).position.x, asteroidsList.get(i).position.y) < padding) {
      setup();
      scoreFuel = 0;
    }

    if (dist(spaceShip.shipBottom.x, spaceShip.shipBottom.y, asteroidsList.get(i).position.x, asteroidsList.get(i).position.y) < padding) {
      setup();
      scoreFuel = 0;
    }
  }
}