class BambooShoots {

  //Data
  PVector position;
  PVector velocity;

  float sproutLocation;
  color bambooColor;

  //Constructor
  BambooShoots() {

    bambooColor = color (random(60, 100), random (139, 246), random(60, 118));
    sproutLocation = random(100, 250);

    //Assign random value to position.x since only y is needed
    position = new PVector (0, 540);
    velocity = new PVector (random(0.001, 0.3), random(0.001, 0.3));
    
  }
  
  /*-------------------------------------------------*/

  void display() {
    
    rectMode(CORNERS);
    noStroke();

    //Draws bamboo shoot
    fill(bambooColor);
    rect(sproutLocation, 550, sproutLocation-10, position.y);

    //Draws leaves once the height of the bamboo is high enough that the leaves don't appear below the soil
    stroke(bambooColor);
    strokeWeight(2);

    if (position.y < 508) {
      line(sproutLocation-10, position.y +40, sproutLocation-20, position.y + 30);
      triangle(sproutLocation-30, position.y+16, sproutLocation-20, position.y+30, sproutLocation-30, position.y+22);
      triangle(sproutLocation-20, position.y+30, sproutLocation-30, position.y+40, sproutLocation-26, position.y+32);
    }

    //reset stroke
    noStroke();
    
  }

  /*-------------------------------------------------*/

  void grow() {
    
    //Makes bambo grow upwards
    position.sub(velocity);

    //Set end game for emotion updates
    if (position.y < 0) {
      gameEnd = true;
    }

    //When mouse is pressed, bamboos grow at a faster rate
    if (mousePressed) {
      velocity.mult(1.01);
    }

    //When mouse isn't pressedm bamboos revert to initial growth rate
    if (!mousePressed) {
      velocity = new PVector (random(0.001, 0.3), random(0.001, 0.3));
    }
  }
}