class Player {

  float xpos;
  float ypos;
  float diam;
  float speed;
  float movs;
  float barrierMovement = -300;
  float[] trailx = new float [3];

  Player(float tempxpos, float tempypos, float tempdiam, float tempspeed, float tempmovs) {
    xpos = tempxpos;
    ypos = tempypos;
    diam = tempdiam;
    speed = tempspeed;
    movs = tempmovs;
  }

  // Character Display
  void display() {

    colorMode(RGB);
    noStroke();
    ellipseMode(CENTER);

    // Draw Player Trail
    for (int i = 0; i<=2; i++) {
      trailx[i] = xpos;
      fill(255, 255, 255, 60);
      ellipse(trailx[i] - movs *3 * (1+i), ypos, 25, 25);
    }
    // Draw Character
    fill(255);
    ellipse(xpos, ypos, diam, diam);
  }

  void controls() {
    // x position is affected by movspeed
    xpos = xpos + movs;

    ypos = ypos + speed;
    speed = speed + 0.2;






    // Moves barriers to make it seem as if progressing through level    
    //First Barrier
    one.starttopPos.x = one.starttopPos.x - movs*2;
    one.startbottomPos.x = one.startbottomPos.x - movs*2;

    one.abovetopPos.x = one.abovetopPos.x - movs*2;
    one.abovebottomPos.x = one.abovebottomPos.x - movs*2;

    one.belowtopPos.x = one.belowtopPos.x - movs*2;
    one.belowbottomPos.x = one.belowbottomPos.x - movs*2;

    //2nd Barrier
    two.starttopPos.x = two.starttopPos.x - movs*2;
    two.startbottomPos.x = two.startbottomPos.x - movs*2;

    two.abovetopPos.x = two.abovetopPos.x - movs*2;
    two.abovebottomPos.x = two.abovebottomPos.x - movs*2;

    two.belowtopPos.x = two.belowtopPos.x - movs*2;
    two.belowbottomPos.x = two.belowbottomPos.x - movs*2;

    //3rd Barrier
    three.starttopPos.x = three.starttopPos.x - movs*2;
    three.startbottomPos.x = three.startbottomPos.x - movs*2;

    three.abovetopPos.x = three.abovetopPos.x - movs*2;
    three.abovebottomPos.x = three.abovebottomPos.x - movs*2;

    three.belowtopPos.x = three.belowtopPos.x - movs*2;
    three.belowbottomPos.x = three.belowbottomPos.x - movs*2;

    // Brings back barriers
    if (xpos >450) {

      xpos = xpos + barrierMovement;

      //First Barrier
      one.starttopPos.x = one.starttopPos.x + barrierMovement;
      one.startbottomPos.x = one.startbottomPos.x + barrierMovement;

      one.abovetopPos.x = one.abovetopPos.x + barrierMovement;
      one.abovebottomPos.x = one.abovebottomPos.x + barrierMovement;

      one.belowtopPos.x = one.belowtopPos.x + barrierMovement;
      one.belowbottomPos.x = one.belowbottomPos.x + barrierMovement;

      //2nd Barrier
      two.starttopPos.x = two.starttopPos.x + barrierMovement;
      two.startbottomPos.x = two.startbottomPos.x + barrierMovement;

      two.abovetopPos.x = two.abovetopPos.x + barrierMovement;
      two.abovebottomPos.x = two.abovebottomPos.x + barrierMovement;

      two.belowtopPos.x = two.belowtopPos.x + barrierMovement;
      two.belowbottomPos.x = two.belowbottomPos.x + barrierMovement;

      //3rd Barrier
      three.starttopPos.x = three.starttopPos.x + barrierMovement;
      three.startbottomPos.x = three.startbottomPos.x + barrierMovement;

      three.abovetopPos.x = three.abovetopPos.x + barrierMovement;
      three.abovebottomPos.x = three.abovebottomPos.x + barrierMovement;

      three.belowtopPos.x = three.belowtopPos.x + barrierMovement;
      three.belowbottomPos.x = three.belowbottomPos.x + barrierMovement;
    }



    //Left Right
    if (left == true) {

      movs = movs - 0.1;
      movs = constrain(movs, -4, 4);
    } else if (right == true) {
      movs = movs + 0.1;
      movs = constrain(movs, -4, 4);
    }

    // when neither left or right key is pressed decrease the speed of the character 
    if (right == false && left == false) {
      movs = movs * 0.95;
    }
  }


  void constrainplayer() {

    //circle does not go through floor
    if (ypos >= height - diam/2) {
      ypos = height - diam/2;
      jumped = false;
      speed = speed * -0.5;
    }
    //circle does not go through roof
    if (ypos <= 0 + diam/2) {
      ypos = 0 + diam/2;
      speed = speed - 0.001;
      speed = speed * -0.1;
    }
    // cicrcle does not go through sides
    if (xpos <= 0 + diam/2) {
      xpos = diam/2;
      movs = 0;
    } else if (xpos >= width - diam/2) {
      xpos = width - diam/2;
      movs = 0;
    }
    //Moves ball away from corners so it doesn't get stuck
    if (xpos <= 0 + diam/2) {
      movs = movs + 0.1;
    } else if (xpos >= width - diam/2) {
      movs = movs - 0.1;
    }
  }

  //Collisions
  void collision() {

    ////COLLISION WITH STARTING BARRIER
    //Top (GROUND)
    if (ypos >= one.starttopPos.y - diam/2 && xpos <= one.startbottomPos.x  && xpos >= one.starttopPos.x ) {
      ypos = one.starttopPos.y - diam/2;
      speed = speed * -0.4;
      jumped = false;
    }       

    // Left Wall
    if (xpos >= one.starttopPos.x - diam/2 && ypos >=  one.starttopPos.y && xpos <= one.startbottomPos.x) {
      xpos = one.starttopPos.x - diam/2;
      movs = movs *- 0.3;
    }

    // Right Wall
    if (xpos <= one.startbottomPos.x + diam/2 && ypos >=  one.starttopPos.y + diam/2 && xpos >= one.startbottomPos.x) {
      xpos = one.startbottomPos.x + diam/2;
      movs = movs + 0.3;
    }


    ////COLLISION WITH BARRIER ONE////

    //TOP OF BARRIER
    //Bottom (ROOF)
    if (ypos <= one.abovebottomPos.y + diam/2 && xpos >= one.abovetopPos.x && xpos <= one.abovebottomPos.x) {
      ypos = one.abovebottomPos.y + diam/2;
      speed = speed - 0.001;
      speed = speed * -0.4;
    }
    // Left Wall
    if (xpos >= one.abovetopPos.x - diam/2 && ypos <=  one.abovebottomPos.y && xpos <=  one.abovetopPos.x) {
      xpos = one.abovetopPos.x - diam/2 ;
      movs = movs *- 0.3;
    }

    // Right Wall
    if (xpos <= one.abovebottomPos.x + diam/2 && ypos >=  one.abovetopPos.y && xpos >=  one.abovetopPos.x && ypos <=  one.abovebottomPos.y) {
      xpos = one.abovebottomPos.x + diam/2;
      movs = movs * 0.3;
    }



    //BOTTOM OF BARRIER
    //Top (GROUND)
    if (ypos >= one.belowtopPos.y - diam/2 && xpos <= one.belowbottomPos.x && xpos >= one.belowtopPos.x) {
      ypos = one.belowtopPos.y - diam/2;
      speed = speed * -0.4;
      jumped = false;
    }       

    // Left Wall
    if (xpos >= one.belowtopPos.x - diam/2 && ypos >=  one.belowtopPos.y && xpos <=  one.belowtopPos.x) {
      xpos = one.belowtopPos.x - diam/2;
      movs = movs *- 0.3;
    }

    // Right Wall
    if (xpos <= one.belowbottomPos.x + diam/2 && ypos >=  one.belowtopPos.y && xpos >=  one.belowtopPos.x) {
      xpos = one.belowbottomPos.x + diam/2;
      movs = movs * 0.3;
    }

    ////COLLISION WITH BARRIER TWO////

    //TOP OF BARRIER
    //Bottom (ROOF)
    if (ypos <= two.abovebottomPos.y + diam/2 && xpos >= two.abovetopPos.x && xpos <= two.abovebottomPos.x) {
      ypos = two.abovebottomPos.y + diam/2;
      speed = speed - 0.001;
      speed = speed * -0.1;
    }
    // Left Wall
    if (xpos >= two.abovetopPos.x - diam/2 && ypos <=  two.abovebottomPos.y && xpos <=  two.abovetopPos.x) {
      xpos = two.abovetopPos.x - diam/2 ;
      movs = movs *- 0.3;
    }

    // Right Wall
    if (xpos <= two.abovebottomPos.x + diam/2 && ypos >=  two.abovetopPos.y && xpos >=  two.abovetopPos.x && ypos <=  two.abovebottomPos.y) {
      xpos = two.abovebottomPos.x + diam/2;
      movs = movs * 0.3;
    }



    //BOTTOM OF BARRIER
    //Top (GROUND)
    if (ypos >= two.belowtopPos.y - diam/2 && xpos <= two.belowbottomPos.x && xpos >= two.belowtopPos.x) {
      ypos = two.belowtopPos.y - diam/2;
      speed = speed * -0.4;
      jumped = false;
    }       

    // Left Wall
    if (xpos >= two.belowtopPos.x - diam/2 && ypos >=  two.belowtopPos.y && xpos <=  two.belowtopPos.x) {
      xpos = two.belowtopPos.x - diam/2;
      movs = movs *- 0.3;
    }

    // Right Wall
    if (xpos <= two.belowbottomPos.x + diam/2 && ypos >=  two.belowtopPos.y && xpos >=  two.belowtopPos.x) {
      xpos = two.belowbottomPos.x + diam/2;
      movs = movs * 0.3;
    }

    ////COLLISION WITH BARRIER THREE////

    //TOP OF BARRIER
    //Bottom (ROOF)
    if (ypos <= three.abovebottomPos.y + diam/2 && xpos >= three.abovetopPos.x && xpos <= three.abovebottomPos.x) {
      ypos = three.abovebottomPos.y + diam/2;
      speed = speed - 0.001;
      speed = speed * -0.1;
    }
    // Left Wall
    if (xpos >= three.abovetopPos.x - diam/2 && ypos <=  three.abovebottomPos.y && xpos <=  three.abovetopPos.x) {
      xpos = three.abovetopPos.x - diam/2 ;
      movs = movs *- 0.3;
    }

    // Right Wall
    if (xpos <= three.abovebottomPos.x + diam/2 && ypos >=  three.abovetopPos.y && xpos >=  three.abovetopPos.x && ypos <=  three.abovebottomPos.y) {
      xpos = three.abovebottomPos.x + diam/2;
      movs = movs * 0.3;
    }



    //BOTTOM OF BARRIER
    //Top (GROUND)
    if (ypos >= three.belowtopPos.y - diam/2 && xpos <= three.belowbottomPos.x && xpos >= three.belowtopPos.x) {
      ypos = three.belowtopPos.y - diam/2;
      speed = speed * -0.4;
      jumped = false;
    }       

    // Left Wall
    if (xpos >= three.belowtopPos.x - diam/2 && ypos >=  three.belowtopPos.y && xpos <=  three.belowtopPos.x) {
      xpos = three.belowtopPos.x - diam/2;
      movs = movs *- 0.3;
    }

    // Right Wall
    if (xpos <= three.belowbottomPos.x + diam/2 && ypos >=  three.belowtopPos.y && xpos >=  three.belowtopPos.x) {
      xpos = three.belowbottomPos.x + diam/2;
      movs = movs * 0.3;
    }
  }
}