/*Bubble Bath
by Blake Koetsier 10/19/2016
Fill the tub with water by clicking on the faucet.
Place the bubble liquid above the tub to create a bubble bath.
Click the drain chain to drain the tub. */

Tile tile;
BubbleBottle bubblebottle;
Bubbles[] bubble = new Bubbles[100];

void setup() {
  size(400,400);
  rectMode(CORNERS);
  ellipseMode(CENTER);
  smooth();
  tile = new Tile();
  bubblebottle = new BubbleBottle();
  for (int i = 0; i < bubble.length; i++) {
    bubble[i] = new Bubbles();
  }
}

boolean faucet = false;
boolean bubblefluid = false;
boolean water = false;
boolean bubblebath = false;

void draw() {
  frameRate(60);
  
  background(#5CA9CB);
  strokeWeight(5);
  //spawns bubbles when all conditions have been met
  stroke(#D3D3D3);
  fill(#FFFFFF, 127);
  if(bubblebath == true) {
    for (Bubbles i : bubble) {
      i.update();
    }
  }
  fill(#2E7DB7);
  stroke(#164D76);
  //draw water from faucet if faucet is on
  if(faucet == true) {
    rect(365,180,375,220);
  }
  stroke(#B6B8B9);
  fill(#FFFFFF);
  //draws the bathtub
  quad(80,300, 320,300, 400,220, 0,220);
  //draws the bathtub legs
  quad(70,290, 80,300, 40,340, 20,340);
  quad(330,290, 320,300, 360,340, 380,340);
  //draw tiles
  tile.tileFunction();
  //draw faucet
  fill(#959798);
  stroke(#525252);
  strokeWeight(3);
  rect(370,160, 410,180);
  quad(360,170, 380,180, 380,190, 360,190);
  triangle(360,170, 370,160, 380,180);
  noStroke();
  quad(362,185, 362,170, 379,162, 379,185);
  quad(400,162, 370,162, 373,179, 400,178);
  //draw bottle of bubble fluid
  strokeWeight(3);
  stroke(#B6B8B9);
  fill(#FFFFFF);
  bubblebottle.bubbleFunction();
  //draws plug for tub
  stroke(#626161);
  fill(#000000, 0);
  line(320,220, 320,250);
  ellipse(320,255, 5,5);
}

void mousePressed() {
  //draws water coming from faucet and fills tub with water
  if(mouseX>=360 && mouseY<=190 && mouseX<=400 && mouseY>=160) {
    faucet = !faucet;
    water = true;
  }
  //checks to see if bubble bottle is picked up or not
  if(mouseX>=0 && mouseY>=290 && mouseX<=20 && mouseY<=340) {
    bubblefluid = !bubblefluid;
  }
  //checks if tub is full of water and bubble fluid has been placed in tub
  if(bubblefluid == true && water == true && mouseY<=220 && mousePressed) {
    bubblebath = true;
    bubblefluid = false;
  }
  if(mouseX>=315 && mouseY>=220 && mouseX<=325 && mouseY<=260) {
    faucet = false;
    bubblefluid = false;
    bubblebath = false;
    water = false;
    setup();
  }
}