class Animol{
  public PVector position = new PVector(0,0);
  PVector speed = new PVector(0,0);
  float acel = 0.5;
  float maxSpeed = .8;
  float fricCoef = 0.85;
  PVector toPlayer;
  PVector lookDir;
  Group group;
  
  PVector wanderDir = new PVector(random(1)-.5,random(1)-.5);
  
  Animol(float x, float y){
    position.x = x;
    position.y = y;
  }
  
  public void update(){
    toPlayer = new PVector(player.position.x - position.x, player.position.y - position.y);

    switch(group.stage){ 
    case 3 :
      lookDir =  new PVector(group.center().x - position.x, group.center().y - position.y); //look at eachother if in stage 3
      break;
    case 2 :
      lookDir = group.moveDirection;
      //maxSpeed = 300/(toPlayer.mag()+100);
      speed.add(group.moveDirection);
      speed.add(wanderDir);
    break;
    case 1:
      lookDir = new PVector(player.position.x - position.x, player.position.y - position.y); //look at player if in stage 1;
      break;
    }
    
    lookDir.normalize();
    lookDir.mult(3);
    
    //impose speed limit
    if(speed.mag() > maxSpeed){
      speed.normalize();
      speed.mult(maxSpeed);
    }
    
    position.add(speed);
    speed.mult(fricCoef);
  }
  
  public void display(){
    PVector camPos = camera.camCoords(position);
    ellipseMode(CENTER);
    fill(255);
    ellipse(camPos.x,camPos.y,25,25);
    switch(group.species){
      case 0 : //bear
        ellipse(camPos.x +9, camPos.y -9, 6, 6);
        ellipse(camPos.x -9, camPos.y -9, 6, 6);
        break;
      case 1 : //dog
        triangle(camPos.x - 18, camPos.y - 10, camPos.x - 12, camPos.y - 10, camPos.x - 16, camPos.y - 1);
        triangle(camPos.x + 18, camPos.y - 10, camPos.x + 12, camPos.y - 10, camPos.x + 16, camPos.y - 1);
        break;
      case 2 : //fish
        triangle(camPos.x - 14, camPos.y + 15, camPos.x - 10, camPos.y + 15, camPos.x - 10, camPos.y + 8);
        triangle(camPos.x + 14, camPos.y + 15, camPos.x + 10, camPos.y + 15, camPos.x + 10, camPos.y + 8);
        triangle(camPos.x + 14, camPos.y, camPos.x + 20 + sin(frameCount*.2), camPos.y - 6, camPos.x+20 + sin(frameCount*.2), camPos.y+6);
        break;
      case 3 : //goat
        ellipse(camPos.x +10, camPos.y -9, 8, 4);
        ellipse(camPos.x -10, camPos.y -9, 8, 4);
        triangle(camPos.x - 10, camPos.y-5, camPos.x-6,camPos.y - 15, camPos.x-1, camPos.y-10);
        triangle(camPos.x + 10, camPos.y-5, camPos.x+6,camPos.y - 15, camPos.x+1, camPos.y-10);
        break;
    }
    
    fill(0);
    //eyes face in speed direction
    ellipse(camPos.x - 4 + lookDir.x, camPos.y + lookDir.y,3,3);
    ellipse(camPos.x + 4 + lookDir.x, camPos.y + lookDir.y,3,3);
    if(group.stage == 3){ //content face
      //mouth
      rectMode(CENTER);
      ellipse(camPos.x - 2 + lookDir.x, camPos.y +6 + lookDir.y,4,4);
      ellipse(camPos.x + 2 + lookDir.x, camPos.y +6 + lookDir.y,4,4);
      fill(255);
      ellipse(camPos.x - 2 + lookDir.x, camPos.y +5 + lookDir.y,3,3);
      ellipse(camPos.x + 2 + lookDir.x, camPos.y +5 + lookDir.y,3,3);
    }
    else if(group.stage == 1){ //discontent face
      fill(0);
      rect(camPos.x+lookDir.x, camPos.y+lookDir.y+6,1,3);
      rect(camPos.x+lookDir.x, camPos.y+lookDir.y+8,5,1);
    }
    else if(group.stage == 2){ //GRRR angery
      //eyebrows
      stroke(0);
      line(camPos.x+lookDir.x - 8, camPos.y+lookDir.y-6,camPos.x+lookDir.x - 2,camPos.y+lookDir.y-4);
      line(camPos.x+lookDir.x + 8, camPos.y+lookDir.y-6,camPos.x+lookDir.x + 2,camPos.y+lookDir.y-4);
      noStroke();
      //mouth
      fill(0);
      rect(camPos.x+lookDir.x, camPos.y+lookDir.y+6,1,3);
      triangle(camPos.x+lookDir.x, camPos.y+lookDir.y+5,camPos.x+lookDir.x+4, camPos.y+lookDir.y+8,camPos.x+lookDir.x-4, camPos.y+lookDir.y+8);
      fill(255);
      triangle(camPos.x+lookDir.x, camPos.y+lookDir.y+7,camPos.x+lookDir.x+4, camPos.y+lookDir.y+10,camPos.x+lookDir.x-4, camPos.y+lookDir.y+10);
    }
    //nose
    fill(0);
    ellipse(camPos.x+lookDir.x, camPos.y+lookDir.y+4,4,2);
  }
  
  public void setGroup(Group _group){
    this.group = _group;
  }
  
  public void genWanderDir(){
    wanderDir = new PVector(random(1)-.5,random(1)-.5);
  }
}