class Group { //helps the cliques organise themselves
  public Animol[] groupMembers;
  ArrayList<Triangle> tris = new ArrayList<Triangle>();
  private Timer stage1Timer = new Timer(2500); //1 second

  public int stage = 3;
  public int species = 1;
  public PVector moveDirection = new PVector(0, 0);
  PVector stage2PlayerPoint;

  Group(Animol[] animols, int spec) {
    species = spec;
    groupMembers = animols;
    for (Animol animol : groupMembers) {
      animol.setGroup(this);
    }
    generateAllTriangles();
  }

  public void display() {
    stroke(255, 100, 100, 140);
    if (stage == 1 || stage == 3) {
      for (Triangle tri : tris) {
        tri.display();
      }
    }
    noStroke();
  }

  public void update() {
    stage1Timer.update();

    PVector myCenter=center();
    myCenter.sub(player.position);
    float myCenterMag=myCenter.mag();
    if (stage == 3 && myCenterMag < 300) {
      for (Triangle tri : tris) {
        //check for collision
        if (tri.getLineAB().circleCollision(player.position, 13)||
          tri.getLineBC().circleCollision(player.position, 13)||
          tri.getLineCA().circleCollision(player.position, 13)) {
          stage = 1;
          stage1Timer.start();
        }
      }
    }
    //start stage 2
    if (stage1Timer.finished && stage == 1) {
      stage = 2;
      player.avoidTriggers ++;
      //stage2PlayerPoint = player.position.copy();
      stage2PlayerPoint = new PVector(player.position.x, player.position.y);
      //moveDirection = center().sub(stage2PlayerPoint).normalize();

      PVector moveDirection=center();
      moveDirection.sub(stage2PlayerPoint);
      moveDirection.normalize();

      for (Animol animol : groupMembers) {
        animol.genWanderDir();
      }
    }
    //stage 2
    if (stage == 2) {
      //float toCenter = center().sub(stage2PlayerPoint).mag();


      PVector toCenterVector=center();
      toCenterVector.sub(stage2PlayerPoint);
      float toCenter=toCenterVector.mag();
      
      //condition to switch to stage 3
      if (stage == 2 && toCenter > 300) {
        stage = 3;
        generateAllTriangles();
      }
    }
  }

  public PVector center() {
    float totalX = 0;
    float totalY = 0;
    for (Animol animol : groupMembers) {
      totalX += animol.position.x;
      totalY += animol.position.y;
    }
    return new PVector(totalX/groupMembers.length, totalY/groupMembers.length);
  }

  public Animol closest(PVector point) {
    float leastMag = 2000;
    Animol closestOne = null;
    for (Animol animol : groupMembers) {
      if (point.dist(animol.position) < leastMag) {
        leastMag = point.dist(animol.position);
        closestOne = animol;
      }
    }
    return closestOne;
  }

  public void generateAllTriangles() {
    tris = new ArrayList<Triangle>();
    for (int a = 0; a < groupMembers.length; a++) {
      PVector posA = groupMembers[a].position;
      for (int b = 0; b < groupMembers.length; b++) {
        PVector posB = groupMembers[b].position;
        if (posB == posA) break;
        for (int c = 0; c < groupMembers.length; c++) {
          PVector posC = groupMembers[c].position;
          if (posC == posA || posC == posB) break;

          Triangle dTris = new Triangle(posA, posB, posC);

          PVector center = dTris.getCircumcircleCenter();
          fill(0, 0, 0, 0);

          float radius = center.dist(posA);
          boolean delauneyCircumcircle = true;
          for (int p = 0; p < groupMembers.length; p++) {
            if (groupMembers[p].position.dist(center) < radius * .99) {
              delauneyCircumcircle = false;
              break;
            }
          }    
          if (delauneyCircumcircle) {
            tris.add(dTris);
          }
        }
      }
    }
  }
}