class Line {
  PVector a;
  PVector b;

  Line(PVector _a, PVector _b) {
    a = _a;
    b = _b;
  }

  public void display() {
    PVector camA = camera.camCoords(a);
    PVector camB = camera.camCoords(b);
    line(camA.x, camA.y, camB.x, camB.y);
  }

  public float slope() {
    float maxX = (b.x > a.x) ? b.x : a.x;
    float minX = (b.x > a.x) ? a.x : b.x;
    float maxY = (b.y > a.y) ? b.y : a.y;
    float minY = (b.y > a.y) ? a.y : b.y;
    return (maxX - minX)/(maxY - minY);
  }

  public float parallelSlope() {
    float maxX = (b.x > a.x) ? b.x : a.x;
    float minX = (b.x > a.x) ? a.x : b.x;
    float maxY = (b.y > a.y) ? b.y : a.y;
    float minY = (b.y > a.y) ? a.y : b.y;
    return -(maxY - minY)/(maxX - minX);
  }

  public float yInt(float slope) {
    // c = y - mx
    return(a.y - slope*a.x);
  }

  //uses this tutorial: https://code.tutsplus.com/tutorials/quick-tip-collision-detection-between-a-circle-and-a-line--active-10546
  public boolean circleCollision(PVector position, float radius) {
    boolean collides = false;

    //uses vector projection to project the perpendicular distance of the circle
    //PVector distanceVectorA = position.copy().sub(a);
    //PVector line = b.copy().sub(a);
    //PVector perpLine = line.copy().normalize().rotate(HALF_PI);

    PVector distanceVectorA = new PVector(position.x, position.y);
    distanceVectorA.sub(a);

    PVector line = new PVector(b.x, b.y);
    line.sub(a);

    PVector perpLine = new PVector(line.x, line.y);
    perpLine.normalize();
    perpLine.rotate(HALF_PI);



    //dot product of normal and distance. This is the projection.
    float distanceToLine = perpLine.x * distanceVectorA.x + distanceVectorA.y * perpLine.y;

    //checks to see if the point is inside the line.
    //PVector distanceVectorB = position.copy().sub(b);

    PVector distanceVectorB = new PVector(position.x, position.y);
    distanceVectorB.sub(b);



    float dotAP = line.x * distanceVectorA.x + distanceVectorA.y * line.y;
    float dotBP = line.x * distanceVectorB.x + distanceVectorB.y * line.y;

    //if the distance to the center is less than the radius then it collides
    //if the dot products are like this then in means that the point is within the line. Not sure how this works, but it does.
    if (Math.abs(distanceToLine) < radius  && (dotAP >= 0 && dotBP <= 0))
      collides = true;

    return collides;
  }
}