class Player {
  public PVector position = new PVector(0, 0);
  PVector speed = new PVector(0, 0);
  float acel = 0.5;
  float maxSpeed = 2.2;
  float fricCoef = 0.87;
  public int avoidTriggers = 0; 

  PVector lookDir;

  public void update() {
    if (keyUp) speed.y -= acel;
    if (keyDown) speed.y += acel;
    if (keyLeft) speed.x -= acel;
    if (keyRight) speed.x += acel;

    //impose speed limit
    if (speed.mag() > maxSpeed) {
      speed.normalize();
      speed.mult(maxSpeed);
    }
    position.add(speed);
    speed.mult(fricCoef);
    lookDir=new PVector(speed.x, speed.y);
    lookDir.normalize();

    //lookDir = speed.copy().normalize();
    lookDir.mult(3);
  }

  public void display() {
    PVector camPos = camera.camCoords(position);
    ellipseMode(CENTER);
    fill(255);
    ellipse(camPos.x, camPos.y, 25, 25);
    triangle(camPos.x - 12, camPos.y-5, camPos.x-14, camPos.y - 15, camPos.x-1, camPos.y-10);
    triangle(camPos.x + 12, camPos.y-5, camPos.x+14, camPos.y - 15, camPos.x+1, camPos.y-10);
    drawExpression();
  }

  void drawExpression() {
    PVector camPos = camera.camCoords(position);
    fill(0);
    //eyes face in speed direction
    ellipse(camPos.x - 4 + lookDir.x, camPos.y + lookDir.y, 3, 3);
    ellipse(camPos.x + 4 + lookDir.x, camPos.y + lookDir.y, 3, 3);
    if (avoidTriggers < 1) {
      //mouth
      rectMode(CENTER);
      ellipse(camPos.x - 2 + lookDir.x, camPos.y +6 + lookDir.y, 4, 4);
      ellipse(camPos.x + 2 + lookDir.x, camPos.y +6 + lookDir.y, 4, 4);
      fill(255);
      ellipse(camPos.x - 2 + lookDir.x, camPos.y +5 + lookDir.y, 3, 3);
      ellipse(camPos.x + 2 + lookDir.x, camPos.y +5 + lookDir.y, 3, 3);
    } else if (avoidTriggers < 25) {
      //eyebrows
      stroke(0);
      line(camPos.x+lookDir.x - 6, camPos.y+lookDir.y-3, camPos.x+lookDir.x - 3, camPos.y+lookDir.y-6);
      line(camPos.x+lookDir.x + 6, camPos.y+lookDir.y-3, camPos.x+lookDir.x + 3, camPos.y+lookDir.y-6);
      noStroke();
      //mouth
      fill(0);
      rect(camPos.x+lookDir.x, camPos.y+lookDir.y+6, 1, 3);
      triangle(camPos.x+lookDir.x, camPos.y+lookDir.y+5, camPos.x+lookDir.x+4, camPos.y+lookDir.y+8, camPos.x+lookDir.x-4, camPos.y+lookDir.y+8);
      fill(255);
      triangle(camPos.x+lookDir.x, camPos.y+lookDir.y+7, camPos.x+lookDir.x+4, camPos.y+lookDir.y+10, camPos.x+lookDir.x-4, camPos.y+lookDir.y+10);
    } else { // if you do it 25 times you become angry
      //eyebrows
      stroke(0);
      line(camPos.x+lookDir.x - 6, camPos.y+lookDir.y-6, camPos.x+lookDir.x - 3, camPos.y+lookDir.y-3);
      line(camPos.x+lookDir.x + 6, camPos.y+lookDir.y-6, camPos.x+lookDir.x + 3, camPos.y+lookDir.y-3);
      noStroke();
      //mouth
      fill(0);
      rect(camPos.x+lookDir.x, camPos.y+lookDir.y+6, 1, 3);
      triangle(camPos.x+lookDir.x, camPos.y+lookDir.y+5, camPos.x+lookDir.x+4, camPos.y+lookDir.y+8, camPos.x+lookDir.x-4, camPos.y+lookDir.y+8);
      fill(255);
      triangle(camPos.x+lookDir.x, camPos.y+lookDir.y+7, camPos.x+lookDir.x+4, camPos.y+lookDir.y+10, camPos.x+lookDir.x-4, camPos.y+lookDir.y+10);
    }
    //nose
    fill(0);
    ellipse(camPos.x+lookDir.x, camPos.y+lookDir.y+4, 4, 2);
  }
}