class Triangle{
  
  public PVector a;
  public PVector b;
  public PVector c;
  
  private Line ab;
  private Line bc;
  private Line ca;
  
  Triangle(PVector _a, PVector _b, PVector _c){
    a = _a;
    b = _b;
    c = _c;
    ab = new Line(a,b);
    bc = new Line(b,c);
    ca = new Line(c,a);
  }
  
  public void display(){
    getLineAB().display();
    getLineBC().display();
    getLineCA().display();
  }
  
  public PVector getCircumcircleCenter(){
    Line line1 = getLineAB();
    Line line2 = getLineBC();

    PVector line1MidPoint = new PVector((line1.a.x + line1.b.x)/2, (line1.a.y + line1.b.y)/2);
    PVector line2MidPoint = new PVector((line2.a.x + line2.b.x)/2, (line2.a.y + line2.b.y)/2);
    float slope1 = -1*(line1.b.x - line1.a.x)/(line1.b.y - line1.a.y);
    float slope2 = -1*(line2.b.x - line2.a.x)/(line2.b.y - line2.a.y);
    float yint1 = line1MidPoint.y - slope1*line1MidPoint.x;
    float yint2 = line2MidPoint.y - slope2*line2MidPoint.x;

    float ix = (yint2 - yint1)/(slope1 - slope2);
    float iy = slope1 * ix + yint1;
    return new PVector(ix,iy);
  }
  
  public Line getLineAB(){
      ab = new Line(a,b);
      return ab;
  }
  
  public Line getLineBC(){
      bc = new Line(b,c);
      return bc;
  }
  
  public Line getLineCA(){
      ca = new Line(c,a);
      return ca;
  }
  
}