//=====================================//
//          Outcat by Brian Ho         //
//=====================================//

Player player = new Player();
Camera camera = new Camera();
float worldSize = 2000; //square world
boolean keyUp, keyLeft, keyRight, keyDown;
Animol[] animols = new Animol[24];
Group bears;
Group dogs;
Group fish;
Group cows;

//class Keys {boolean up = false; boolean down = false; boolean left = false; boolean right = false;}
//Keys keys = new Keys();

void setup(){
  size(400,400,P2D);
  smooth(5);
  frameRate(60);
  noStroke();
  animols[0] = new Animol(150, -175);
  animols[1] = new Animol(250, -155);
  animols[2] = new Animol(130, -90);
  animols[3] = new Animol(180, -60);
  animols[4] = new Animol(70, -130);
  animols[5] = new Animol(110, -185);
  animols[6] = new Animol(60, 0);
  Animol[] tempBears = {animols[0],animols[1],animols[2],animols[3],animols[4],animols[5],animols[6]};
  bears = new Group(tempBears,0);
  
  animols[7] = new Animol(-100, -145);
  animols[8] = new Animol(-250, -70);
  animols[9] = new Animol(-135, -90);
  animols[10] = new Animol(-115, -43);
  animols[11] = new Animol(-180, -130);
  animols[12] = new Animol(-215, -140);
  Animol[] tempDogs = {animols[7],animols[8],animols[9],animols[10],animols[11],animols[12]};
  dogs = new Group(tempDogs,1);
  
  animols[13] = new Animol(-400, -145);
  animols[14] = new Animol(-350, -270);
  animols[15] = new Animol(-437, -290);
  animols[16] = new Animol(-380, -243);
  animols[17] = new Animol(-460, -330);
  animols[18] = new Animol(-415, -340);
  Animol[] tempFish = {animols[13],animols[14],animols[15],animols[16],animols[17],animols[18]};
  fish = new Group(tempFish,2);
  
  animols[19] = new Animol(100, 245);
  animols[20] = new Animol(57, 270);
  animols[21] = new Animol(137, 290);
  animols[22] = new Animol(-50, 220);
  animols[23] = new Animol(80, 330);

  Animol[] tempCows = {animols[19],animols[20],animols[21],animols[22],animols[23]};
  cows = new Group(tempCows,3);
}

void draw(){
  //update all
  player.update();
  camera.position = new PVector(player.position.x - 200,player.position.y - 200);
  bears.update();
  dogs.update();
  fish.update();
  cows.update();
  for(int i = 0; i < animols.length; i++){
    animols[i].update();
  }
  
  //drawing
  background(0);
  createParallaxGrid();
  bears.display();
  dogs.display();
  fish.display();
  cows.display();
  for(int i = 0; i < animols.length; i++){
    animols[i].display();
  }
  player.display();
}


void createParallaxGrid(){
  //small grid
  float gridSize = 90;
  float parallaxCoef = 0.5;
  for(float y = 0; y < worldSize*2; y += gridSize){
    for(float x = 0; x < worldSize*2; x += gridSize){
      PVector gridPos = camera.camCoords(new PVector(x-worldSize/2,y-worldSize/2));
      fill(40);
      ellipse(gridPos.x*parallaxCoef, gridPos.y*parallaxCoef, 5, 5);
    }
  }
  //large grid
  gridSize = 40;
  for(float y = 0; y < worldSize; y += gridSize){
    for(float x = 0; x < worldSize; x += gridSize){
      PVector gridPos = camera.camCoords(new PVector(x-worldSize/2,y-worldSize/2));
      fill(70);
      ellipse(gridPos.x, gridPos.y, 7, 7);
    }
  }  
}

//Input handling
void keyReleased(){
  if(keyCode == UP) keyUp = false;
  if(keyCode == DOWN) keyDown = false;
  if(keyCode == LEFT) keyLeft = false;
  if(keyCode == RIGHT) keyRight = false;
}
void keyPressed(){
    if(keyCode == UP) keyUp = true;
  if(keyCode == DOWN) keyDown = true;
  if(keyCode == LEFT) keyLeft = true;
  if(keyCode == RIGHT) keyRight = true;
}

float clamp(float value, float min, float max){
  if(value > max) return max;
  else if(value < min) return min;
  else return value;
}