class Mover {

  PVector location;
  PVector velocity;
  PVector acceleration;
  float capSpeed;
  color colours;
  float tempCapSpeed;
  float sizes;



  Mover() {
    //assign random spawn point to enemy
    location = new PVector(random(-1500, width + 1500), random(-1500, height + 1500));
    
    //make empty velocity vector
    velocity = new PVector(0, 0);
    
    //set maximum enemy speed to 0
    capSpeed = 0;
  }

  //enemies move with random speeds between 0.6 to 1.4 pixels per frame
  void randomSpeed() {
    tempCapSpeed = random(0.6, 1.4);
  }

  //enemies have random size between 10x10 to 40x40 pixels
  void randomSize() {
    sizes = random(0, 30);
  }

  void update() {

    // set finishing enemy position vector to the middle of the screen since that's where the player character always is
    PVector center = new PVector(width/2, height/2);
    //based on enemy's current location, find the vector that points toward the center ( player character)
    PVector dir = PVector.sub(center, location);  
    //accelerate in the direction found above
    acceleration = dir;  

    //add acceleration to velocity to change direction
    velocity.add(acceleration);
    //don't go faster than the maximum speed determined by the function randomSpeed()
    velocity.limit(capSpeed);
    //add velocity to location to move
    location.add(velocity);
    
    //if enemies are outside the screen, they do not move
    if (location.x > 0 && location.x < width && location.y > 0 && location.y < height) {
      capSpeed = tempCapSpeed;
    } else { 
      capSpeed = 0;
    }
  } 

  //set random colour for enemy
  void blobColor() {
    colours = color(random(255), random(255), random(255));
  }

  void display() {
    //black outline
    stroke(0);
    fill(colours); 
    //draw enemy blob with updated location
    ellipse(location.x, location.y, 10 + sizes, 10 + sizes);
    
    //if enemy blob collides with player character, make screen red and print 'you died'
    if (location.x > (width/2 - 20) && location.x < (width/2 + 20) && location.y > (height/2 - 20) && location.y < (height/2 + 20)) {
      fill(157, 0, 0);
      rect(0, 0, width, height);
      println("YOU DIED!");
    }
  }

  //wsad moving functions to be called in keyPressed()
  void moveEnemyW() {
    //if 'w' key is pressed, add moveSpeed to y coordinate of enemy
    location.y += moveSpeed;
  }
  void moveEnemyS() {
    location.y -= moveSpeed;
  }
  void moveEnemyA() {
    location.x += moveSpeed;
  }
  void moveEnemyD() {
    location.x -= moveSpeed;
  }
}