//variables for 4 laser rectangle parameters
float laserX = 0;
float laserY = 0;
float laserWidth = 0;
float laserHeight = 0;

//variables for enemy position 
float yBlob;
float xBlob;

//player movement speed
int moveSpeed = 5;

//make a new array of 200 enemy objects
Mover[] movers = new Mover[200];


void setup() {
  //set screen size
  size(800, 600);

  // initializing the objects of the array 
  for (int i = 0; i < movers.length; i++) {
    movers[i] = new Mover(); 
    //initializing the random colours, speeds and sizes of each enemy object
    movers[i].blobColor();
    movers[i].randomSpeed();
    movers[i].randomSize();
  }
}

void draw() {
  //grey background
  background(80, 74, 74);
  
  //draw player character as static in the middle of the screen
  fill(255);
  ellipse(width/2, height/2, 30, 30);
  fill(0);
  rect(width/2 - 20, height/2 - 3, 40, 6);
  rect(width/2 -3, height/2 - 20, 6, 40);
  ellipse(width/2, height/2, 15, 15);

  // Calling the functions of the enemy objects in the array.
  for (int i = 0; i < movers.length; i++) {
    movers[i].update();
    movers[i].display();
  }
}


void laserCollision() {
  //for each enemy object, determine if collision occurs with laser rectangle
  for (int i = 0; i < movers.length; i++) { 
    if (movers[i].location.x + 10 > laserX && movers[i].location.x - 10 < laserX + laserWidth && movers[i].location.y + 10 > laserY && movers[i].location.y - 10 < laserY + laserHeight) {
      //if collision occurs, move enemy object far away to make it seem like it disappeared
      movers[i].location.x = 10000;
      movers[i].location.y = 10000;
    }
  }
}

void keyPressed() {
  
  //if wsad are pressed, call the moveEnemy functions for all objects in array
  if (key == 'w') {
    for (int i = 0; i < 200; i++) { 
      movers[i].moveEnemyW();
    }
  }
  if (key == 's') {
    for (int i = 0; i < 200; i++) { 
      movers[i].moveEnemyS();
    }
  }
  if (key == 'a') {
    for (int i = 0; i < 200; i++) { 
      movers[i].moveEnemyA();
    }
  }
  if (key == 'd') {
    for (int i = 0; i < 200; i++) { 
      movers[i].moveEnemyD();
    }
  }

//laser colour is red
  fill(255, 0, 0);
  
  //while arrow keys are pressed, display laser rectangle in position that matches arrow key 
  if (keyCode == UP) {
    laserX = (width/2) -1; 
    laserY = 0; 
    laserWidth = 2; 
    laserHeight = height/2;
  } else {
    laserX = 0; 
    laserY = 0; 
    laserWidth = 0; 
    laserHeight = 0;
  }

  if (keyCode == DOWN) {
    laserX = (width/2) -1; 
    laserY = height/2; 
    laserWidth = 2; 
    laserHeight = height/2;
  }

  if (keyCode == LEFT) {
    laserX = 0; 
    laserY = height/2 - 1; 
    laserWidth = width/2; 
    laserHeight = 2;
  }

  if (keyCode == RIGHT) {
    laserX = width/2; 
    laserY = height/2 - 1; 
    laserWidth = width/2; 
    laserHeight = 2;
  }

  rect(laserX, laserY, laserWidth, laserHeight);
  laserCollision();
}