class TopPaw {
  //gloooballl varrriables!
  PVector position=new PVector();
  PVector velocity=new PVector();
  color catColor;
  float pawColor;
  color toeBeanColor;


  TopPaw() {
    init();
  }
  //initialize paw starting positions
  void init() {

    position.x=random(width, 700);
    position.y=random(0, 199);
    velocity.x=-2;
    velocity.y=-2;
    catColor=color(random(100, 200), random(50, 150), random(50, 150));
    pawColor=(255);
    toeBeanColor=(#FFBFBF);
  }

  //function for updating the paws w/ movement
  void update() {
    //move paw from right to left
    position.add(velocity);
    //if paw goes off left of canvas by 100, reset position
    if (position.x<-100) {
      init();
    }
    //if the top of the paw reaches a random position between 150 and 200 px, reverse Y speed
    if (position.y>=random(150, 200)) {
      velocity.y=-2;
    }
    //if the top of the paw reaches a random position between 0 and 20px, reverse Y speed
    if (position.y<=random(0, 20)) {
      velocity.y=2;
    }
  }
  //function for displaying the paws
  void display () {
    rectMode(CORNERS);
    stroke(catColor);
    strokeWeight(1);
    fill(catColor);
    //have the y position at 300 so it clips past the canvas
    rect(position.x-30, position.y+20, position.x+30, position.y-300);
    fill(pawColor);

    //main paw shape
    noStroke();
    ellipse(position.x-40, position.y+120, position.x+40, position.y);

    //toes
    ellipse(position.x-43, position.y+110, position.x-15, position.y+55);
    ellipse(position.x+43, position.y+110, position.x+15, position.y+55);
    ellipse(position.x-17, position.y+97, position.x, position.y+125);
    ellipse(position.x+17, position.y+97, position.x, position.y+125);

    //TOE BEANS.
    fill (toeBeanColor);
    ellipse(position.x-41, position.y+107, position.x-15, position.y+56);
    ellipse(position.x+41, position.y+107, position.x+15, position.y+56);
    ellipse(position.x-15, position.y+95, position.x-1, position.y+123);
    ellipse(position.x+15, position.y+95, position.x+1, position.y+123);

    //pawpad!
    quad(position.x-25, position.y+25, position.x-15, position.y+68, position.x+15, position.y+68, position.x+25, position.y+25);
  }
  /* void topDectector(){
   //created to detect if fly hits the paw
   fill(0,0,0,0);
   rect(position.x-40,position.y,position.x+40,position.y);
   }*/
}