/*
* Boulder Class
* By: Daniel Nava
* Last Updated: October 21 2016
*
* Boulders fall down from the top section of the screen at a constant rate.
* Their X spawn locations are random.
* If they hit the Player, the player's position is reset.
*/
class Boulder {
  
////INSTANCE VARIABLES////

  PVector boulderLocation = new PVector ();

////END OF INSTANCE VARIABLES////

  Boulder(float spawnBoulderX, float spawnBoulderY) {
    boulderLocation.x = spawnBoulderX;
    boulderLocation.y = spawnBoulderY;
  }
  
////BOULDER TO PLAYER COLLISION DETECTION////
  void boulderCollide(PVector playerPos, PVector playerVel) {
   
    //Resets player location if it hits a boulder
    if (playerPos.y >= boulderLocation.y - 10  && playerPos.y <= (boulderLocation.y + 50)
      && playerPos.x >= boulderLocation.x  && playerPos.x <= (boulderLocation.x +  50))
    {
      playerPos.x = 10;
      playerPos.y = 500;
      playerVel.y = 0;
      playerVel.x = 0;
    }
  }

////MOVES BOULDER AT A CONSTANT SPEED IN A FIXED DIRECTION////
  void fall() {
    boulderLocation.y += 3;
  }

////DRAWS BOULDER VISUALS////
  void drawBoulder () {
    //Grey color for boulders
    fill(150);
    rect(boulderLocation.x - 5, boulderLocation.y + 20, 60, 20);
    rect(boulderLocation.x, boulderLocation.y, 50, 50);
  }

////RESETS BOULDER LOCATION ONCE OUT OF SCREEN////
  void boulderRespawn()
  {
    if (boulderLocation.y >= 600) {
      boulderLocation.x = random(100, 400);
      boulderLocation.y = random(-800, 0);
    }
  }

////GROUPS ALL FUNCTIONS INTO ONE////
//makes it easier to place within the main class
  void boulderFunctions() {
    boulderCollide( p1.playerPosition, p1.playerVelocity);
    fall();
    drawBoulder();
    boulderRespawn();
  }
}