/*
* Platform Class
* By: Daniel Nava
* Last Updated: October 21 2016
*
* the Player can land and move on Platforms.
*/

class Platform {
  
////INSTANCE VARIABLES////

  PVector spawnLocation = new PVector ();
  
  float platformH = 10;
  float platformL = 0;
  boolean onFloor = false;
  
////END OF INSTANCE VARIABLES////

  Platform(float x, float y, float l) {
    spawnLocation.x =  x ;
    spawnLocation.y = y ;
    platformL = l;
  }

////DRAWS PLATFORM VISUALS////
  void drawPlatform () {
    //Dark brown color for platforms
    fill(#362818);
    rect(spawnLocation.x, spawnLocation.y, platformL, platformH);
    triangle(spawnLocation.x,spawnLocation.y + 10,spawnLocation.x , spawnLocation.y + 30,spawnLocation.x + 20,spawnLocation.y + 10);
    triangle(spawnLocation.x + 60,spawnLocation.y + 10,spawnLocation.x + 60 , spawnLocation.y + 30,spawnLocation.x + 40,spawnLocation.y + 10);
  }

////PLATFORM TO PLAYER COLLISION DETECTION
  void collisionCheck(PVector playerPos) {
    
    //Allows player to land on platforms 
    if (playerPos.y >= spawnLocation.y - 10  && playerPos.y <= (spawnLocation.y + platformH)
        && playerPos.x >= spawnLocation.x && playerPos.x <= (spawnLocation.x +  platformL)) {
    //notifies the Player class that the Player is on a platform
      this.onFloor = true;
   // Makes sure the player doesn't phase slightly through the platform
     playerPos.y = spawnLocation.y - 10;
    }
    else this.onFloor = false;
  }
}