/*
* Player Class
* By: Daniel Nava
* Last Updated: October 21 2016
*
* The Player can move left and right.
* The Player can also jump.
* If the Player falls of the map or hits a boulder their position is reset to the lowest platform.
* 
*/
class Player {

////INSTANCE VARIABLES////

  PVector playerPosition = new PVector ();
  PVector playerVelocity = new PVector ();

  float speed = 5;

////END OF INSTANCE VARIABLES////

  Player() {  
    playerPosition.x = 0;
    playerPosition.y = 500;
  }

////ALLOWS PLAYER TO JUMP ONLY ON A PLATFORM////
  void jump ( boolean touching) {
    if ( touching ) {  
      playerVelocity.y = 0;

      if (keyPressed == true && key == ' ') {      
        playerVelocity.y = -10;
      }
    } else {
      playerVelocity.y += gravity;
    }
  }

////RESETS PLAYER LOCATION IF GOES OFF SCREEN////
  void playerRespawnFall() {
    if (playerPosition.y >= 600) {
      playerPosition.x = 0;
      playerPosition.y = 500;
    }
  }

////UPDATES PLAYER LOCATION////
  void update () {
    playerVelocity.x = (right - left) * speed;
    playerPosition.add(playerVelocity);
  }

////RESTRICTS PLAYER FROM GOING OFF SCREEN FROM THE SIDES
  void boundaryCheck ()
  {
    //Right side check
    if (playerPosition.x >= width - 10) {
      playerPosition.x = width - 10;
      playerVelocity.x = 0;
    }
    //Left side check
    if (playerPosition.x <= 0) {
      playerPosition.x = 0;
      playerVelocity.x = 0;
    }
  }

////DRAWS PLAYER VISUALS////
  void drawP () {
    fill(0);
    noStroke();
    rect(playerPosition.x, playerPosition.y, 10, 10);
    fill(#29861B);
    beginShape();
    vertex(playerPosition.x-3, playerPosition.y);
    vertex(playerPosition.x, playerPosition.y - 3);
    vertex(playerPosition.x + 5, playerPosition.y - 6);
    vertex(playerPosition.x + 10, playerPosition.y - 3);
    vertex(playerPosition.x + 12, playerPosition.y);
    vertex(playerPosition.x-3, playerPosition.y);
    endShape();
  }

////GROUPS ALL FUNCTIONS INTO ONE////
  void playerFunctions() {
    update();
    boundaryCheck ();
    playerRespawnFall();
    drawP();
  }
}