/*
* Block Boy's Adventure: Escaping Mt. Khan
* By: Daniel Nava
* Last Updated: October 21 2016
*
* Help Block Boy escape Mt. Khan by climbing to the top and dodging the incoming boulders.
* Move left with the "a" key and right with the "d" key. Jump with the spacebar.
* If you fall into the mountain or get hit by a boulder, you will respawn at the lowest platform.
*/

////GLOBAL VARIABLES////

//Variables for player class for the side to side movement and gravity.
float left = 0;
float right = 0;
float gravity = 0.06;

//variable for win screen
boolean winCondition = false;

////END OF GLOBAL VARIABLES////

////CREATING OBJECTS////

Player p1;

//Lower set of Platforms
Platform[] plats = new Platform[4];
//Higher set of platforms
Platform[] plats2 = new Platform[4];

Boulder[] boulds = new Boulder[9];

////END OF OBJECT CREATION////

void setup ()
{
  size(600, 600);

  p1 = new Player ();

  // Lower Platforms
  for (int i = 0; i < plats.length; i++) {
    plats[i] = new Platform (0 + (180 * i), 550 -(50 * i), 60);
  }
  // Higher Platforms
  for (int i = 0; i < plats2.length; i++) {
    plats2[i] = new Platform (0 + (130 * i), 70 +(80 * i), 60);
  }
  for (int i = 0; i < boulds.length; i++) {
    boulds[i] = new Boulder (random(0, 600), random(-800, 0));
  }
}

void draw ()
{
  //Background color is light brown
  background (#795A39);

  drawSky();
  drawSpikes();

  p1.playerFunctions();

  for (int i = 0; i < plats.length; i++) {
    plats[i].collisionCheck(p1.playerPosition);
    p1.jump( plats[i].onFloor);
    plats[i].drawPlatform();
  }
  for (int i = 0; i < plats2.length; i++) {
    plats2[i].collisionCheck(p1.playerPosition);
    p1.jump( plats2[i].onFloor);
    plats2[i].drawPlatform();
  }

  for (int i=0; i < boulds.length; i++) {
    boulds[i].boulderFunctions();
  }

  win();
  reset();
}

////DRAWS MOUNTAIN TOP SPIKES VISUALS////
void drawSpikes() {
  //Spike color is light brown same as background
  fill(#795A39);
  //creates spikes every 150 units for a total of 4 spikes
  for (int i =0; i < 600; i += 150) {
    triangle(0 + i, 60, 60 + i, 20, 120 + i, 60);
  }
}

////DRAWS SKY VISUALS////
void drawSky() {
  //sky color is light blue
  fill(#68CED6);
  rect(0, 0, 600, 60);
}

////CREATES WIN SCREEN////
void win () {
  //creates the win screen only if the player reaches the highest platform
  if (plats2[0].onFloor == true) {
    winCondition = true;
  }

  if (winCondition == true) {
    fill(#29861B);
    rect(0, 0, 600, 600);
    fill(255);
    textSize(30);
    text("You Win!", 230, 300);
    textSize(20);
    text("press R to play again", 210, 350);
  }
}

////RESETS PLAYER LOCATION////
void reset() {
  //resets player location and removes "win" screen 
  if (keyPressed == true && key == 'r' && winCondition == true) {
    p1.playerPosition.y = 500;
    p1.playerPosition.x = 0;
    winCondition = false;
  }
}

////KEYBOARD CHECKS FOR LEFT AND RIGHT MOVMENT CONTROLS////
void keyPressed() {

  if ( key == 'a') {
    left = 1;
  }

  if ( key == 'd') {
    right = 1;
  }
}

////KEYBOARD CHECKS FOR LEFT AND RIGHT MOVMENT CONTROLS////
void keyReleased() {
  if ( key == 'a') {
    left = 0;
  }

  if ( key == 'd') {
    right = 0;
  }
}