//This is the object for the car, an enemy
class Car {

  //Values for the car's hitbox
  float carBoxX= 100;
  float carBoxY= 30;

  //Set PVector
  PVector position = new PVector(), velocity = new PVector();

  //Set initial values for the Car
  Car(float x, float y, float vx, float vy) {

    this.position.x = x;
    this.position.y = y;
    this.velocity.x = vx;
    this.velocity.y = vy;
  }

  //Move Car
  void update() {
    position.add(velocity);
  }

  //Draw the Car
  void display() {
    noStroke();
    fill(76, 107, 63);

    //Draw the car's body
    rect(position.x+20, position.y-20, 60, 30);
    rect(position.x, position.y, 100, 40);

    //Draw the car's wheels
    fill(75, 75, 75);
    ellipse(position.x+20, position.y+40, 30, 30);
    ellipse(position.x+80, position.y+40, 30, 30);

    //Draw the car's hitbox
    fill(0, 0, 0, 0);
    rect(position.x, position.y+5, carBoxX, carBoxY);
  }

  void driveBy() {
    if (position.x > width) {
      position.x = 0;
      position.y = random(height);
    } else if (position.x < 0) {
      position.x = width;
      position.y = random(height);
    }
  }
}