//This is the object for Ugly Reds, the enemy you will be fighting
class UglyRed {

  //Set float vlaues for Ugly Red's hitbox
  float redBoxX = 80;
  float redBoxY = 130;

  float explodeTime = millis();
  float redTime = millis();

  //Set PVector
  PVector position = new PVector(), velocity = new PVector();

  //Set initial values for the Ugly Red
  UglyRed(float x, float y, float vx, float vy) {

    this.position.x = x;
    this.position.y = y;
    this.velocity.x = vx;
    this.velocity.y = vy;
  }


  //Move Ugly Red
  void update() {
    position.add(velocity);
  }

  //Draw Ugly Red
  void display () {
    noStroke();
    fill(109, 147, 39);

    //Draw Ugly Red's clothes
    rect(position.x+-25, position.y+50, 100, 20);
    rect(position.x-5, position.y+70, 60, 20);
    rect(position.x-5, position.y+90, 20, 40);
    rect(position.x+35, position.y+90, 20, 40);

    //Draw the Ugly Red's head
    fill(237, 220, 150);
    rect(position.x, position.y, 50, 50);

    //Draw the Ugly Red's hat
    fill(109, 147, 39);
    rect(position.x-5, position.y, 60, 20);

    //Draw the Ugly Red's eyes
    fill(0, 0, 0);
    rect(position.x+5, position.y+25, 15, 3);
    rect(position.x+30, position.y+25, 15, 3);

    //Draw the Ugly Red's hitbox
    fill(0, 0, 0, 0);
    rect(position.x-15, position.y, redBoxX, redBoxY);
  }

//Randomizes position of the Reds
  void waveOfReds() {
    if (position.y > height) {
      position.y = 0;
      position.x = random(width);
    } else if (position.y < 0) {
      position.y = height;
      position.x = random(width);
    }
  }

//When the Red dies, reset his position
  void redKill() {
    position.y =random(width);
    position.x = 650;
    redTime= 20;
  }

//When Reds die, blow up in a atomic explosion
  void redExplosion() {
    fill(255, 60, 0);
    ellipse(position.x, position.y, 200, 200);
  }
}