/////////////////HONG KONG 2000 OBJECT ORIENTED TOY////////////////////////
///////////////////////BY DEXTER TRUONG////////////////////////////////////

//HONG KONG 2000 IS A SEQUEL TO HAPPYSOFT'S HIT GAME FOR THE FAMICOM HONG KONG 97
//DEFEAT 1.2 BILLION OF THE UGLY REDS AND SAVE HONG KONG
//INSTRUCTIONS: CONTROL THE MOUSE WITH CHIN AND PRESS THE MOUSE TO SHOOT PINGPONG BALLS AT THE UGLY REDS. IF AN UGLY RED OR CAR TOUCHES YOU, YOU DIE. CARS CANNOT BE KILLED
//KILL AS MANY UGLY REDS AS POSSIBLE FOR A HIGH SCORE!!!!!!!!!!

////////////////////////////////////////////////////////////////////////////
//////////////////////////////VERY IMPORTANT////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//REMEMBER TO PLAY THE GAME WITH IT'S APPORPIRATE SOUNDTRACK IN THE BACKGROUND FOR A REAL HONG KONG 97 EXPERIENCE
//https://www.youtube.com/watch?v=MtYF_9e2azE
////////////////////////////////////////////////////////////////////////////
//////////////////////////////VERY IMPORTANT////////////////////////////////
////////////////////////////////////////////////////////////////////////////



///////////////START OF PROGRAM///////////////
//Keep track of player score
float score;

//Call upon objects
UglyRed[] uglyred;
Chin chin;
Car car;
ArrayList <PingPongBall> pingpongballs;



void setup() {
  //Setup size of window
  size(600, 600);

  //Initialize Ugly Red array
  uglyred = new UglyRed[5];

  //Ugly Red constructor
  for (int i = 0; i < uglyred.length; i++) {
    uglyred[i] = new UglyRed(random(width), 0, 0, int(random(3, 10)));
  }

  //Chin constructor
  chin = new Chin(100, 150);

  //Car constructor
  car = new Car(0, random(height), 3, 0);

  //Pingpong Ball constructor
  pingpongballs = new ArrayList();
}



void draw() {  
  {
    //Background colour
    background(0, 0, 75);

    //Call Ugly Reds
    for (int i=0; i < uglyred.length; i++) {
      uglyred[i].update();
      uglyred[i].waveOfReds();
      uglyred[i].display();
    }

    //Call Chin
    chin.update(); 
    chin.display();

    //Call car
    car.update();
    car.driveBy();
    car.display();

  //Call the Pingpong ball array
    PingPongFire();
   
  }


  //When Chin touches the Ugly Red, he dies
  for (int a = 0; a < uglyred.length; a++) {
    if (enemyIntersect(uglyred[a].position.x, uglyred[a].position.y, uglyred[a].position.x+uglyred[a].redBoxX, uglyred[a].position.y+uglyred[a].redBoxY, mouseX, mouseY, mouseX+chin.chinBoxX, mouseY+chin.chinBoxY) == true) {
      gameOver();      
      noLoop();
      println("Your score is" +score);
    }

    //When Chin touches the Car, he dies
    if (enemyIntersect(car.position.x, car.position.y, car.position.x+car.carBoxX, car.position.y+car.carBoxY, mouseX, mouseY, mouseX+chin.chinBoxX, mouseY+chin.chinBoxY) == true) {
      gameOver();
      noLoop();
      println("Your score is" +score);
    }

    //When the Pingpong ball hits the Ugly red, reset the position of the Ugly Red, cause and Atomic Explosion and add 1 to score
    for (int i = 0; i < uglyred.length; i++) {
      for (PingPongBall j : pingpongballs) {
        if (uglyRedPingPongIntersect(uglyred[i].position.x, uglyred[i].position.y, uglyred[i].redBoxX, uglyred[i].redBoxY, j.position.x, j.position.y, j.pingPongRadius) == true) {
          uglyred[i].redExplosion();
          uglyred[i].redKill();
          score++;
        }
      }
    }
  }
}

//When the player presses the mouse Chin fires Pingpong balls
void mousePressed() {
  PingPongBall shot = new PingPongBall(mouseX, mouseY, 0, -10);
  pingpongballs.add(shot);
}

//Function for handling array of Pingpong balls
void PingPongFire() {
  for (PingPongBall shot : pingpongballs) {
    //Call Pingpong balls
    shot.update();
    shot.display();
  }
}


//Game over screen when Chin dies
void gameOver() {
  textSize(90);
  text("CHIN IS DEAD", 0, 300); 
  fill(255, 0, 0); 
}



//Circle-Rect Intersection for Pingpong balls and Ugly Reds
//Inspired by REAS' sketch
//https://www.openprocessing.org/sketch/8004
boolean uglyRedPingPongIntersect(float redX, float redY, float redWidth, float redHeight, float pingPongX, float pingPongY, float pingPongRadius) {

  float pingPongDistanceX = abs(pingPongX - redX - redWidth/2);
  float pingPongDistanceY = abs(pingPongY - redY - redHeight/2);

  if (pingPongDistanceX > (redWidth/2 + pingPongRadius)) { 
    return false;
  }
  if (pingPongDistanceY > (redHeight/2 + pingPongRadius)) { 
    return false;
  }
  if (pingPongDistanceX <= redWidth/2) { 
    return true;
  } 
  if (pingPongDistanceY <= redHeight/2) { 
    return true;
  }

  float cornerDistance = pow(pingPongDistanceX - redWidth/2, 2) + pow(pingPongDistanceY - redHeight/2, 2);
  return cornerDistance <= pow(pingPongRadius, 2);
}


//Rect-Rect Intersection for Ugly Reds, Car and Chin
//Inspired by REAS' sketch
//https://www.openprocessing.org/sketch/8005
boolean enemyIntersect(float left, float top, float right, float bottom, 
  float otherLeft, float otherTop, float otherRight, float otherBottom) {
  return !(left > otherRight || right < otherLeft || top > otherBottom || bottom < otherTop);
}