//class controlling the balls at the bottom of the screen
//used as reference: https://www.openprocessing.org/sketch/104885

class Balls {

  //variables for colours and sizes of balls
  color c;
  int diameter;

  //variables to change position of balls
  PVector position;
  PVector bounce;
  PVector gravity;

  //constructor
  Balls() {
    //placement of ball
    position = new PVector(random(5, 395), height - random(height/2));
    
    //controls speed of ball
    bounce = new PVector(0, -5);
    gravity = new PVector(0, 1);

    //calls colour of balls
    colour();
  }

  void colour() {
    //each ball to be a random colour
    c = color(random(255), random(255), random(255));
  }

  void display() {
    //size of ball
    diameter = 10;
    //makes the balls random colour
    fill(c);
    noStroke();
    //balls will start at random position at bottom of the screen
    ellipse(position.x, position.y, diameter, diameter);
  }

  void move() {
    //creates motion for the balls
    position.y = position.y + bounce.y;
    bounce.y = bounce.y + gravity.y;

    // Condition to make the ball stop
    if (bounce.y < 0.6 && position.y > height - 5) {
      bounce.y = 0;
      gravity.y = 0;
    } else if (position.y > height-5) {
      bounce.y = bounce.y * -0.65;
    }
  }
}