//class to display and control stickman

class Stickman {

  //variables to display stickman
  PVector centre;
  PVector headCentre;
  int head;
  PVector shoulders;
  PVector rightHand;
  PVector leftHand;
  PVector rightFoot;
  PVector leftFoot;

  //variables to create motion
  PVector speed;
  PVector gravity;

  boolean isJumping;

  //constructor
  Stickman() {

    //used to create illusion of jump.
    speed = new PVector(2, -2);
    gravity = new PVector(0, .5);

    //diameter of stickman's head
    head = 5;

    //ensures all variables are relative to the centre of the stickman (his hips)
    centre = new PVector(15, 180);
    headCentre = new PVector(centre.x, centre.y - 20);
    shoulders = new PVector(centre.x, centre.y - 15);
    rightHand = new PVector(centre.x + 10, centre.y - 20);
    leftHand = new PVector(centre.x - 10, centre.y - 20);
    rightFoot = new PVector(centre.x + 10, centre.y + 20);
    leftFoot = new PVector(centre.x - 10, centre.y + 20);

    isJumping = false;
  }

  void display() {
    //draws out stickman
    strokeWeight(2);
    stroke(0);
    fill(0);
    //head
    ellipse(headCentre.x, headCentre.y, head, head);
    //torso
    line(headCentre.x, headCentre.y, centre.x, centre.y);
    //arms
    line(shoulders.x, shoulders.y, rightHand.x, rightHand.y);
    line(shoulders.x, shoulders.y, leftHand.x, leftHand.y);
    //legs
    line(centre.x, centre.y, rightFoot.x, rightFoot.y);
    line(centre.x, centre.y, leftFoot.x, leftFoot.y);

    if (isJumping == true) {
      move();
    }
  }

  //function to make the stickman jump when the mouse is pressed.
  //used this as reference https://www.openprocessing.org/sketch/92234
  void jump() {
    isJumping = true;
    println("This is gr8.");
  }

  void move() {

    centre.x += speed.x;
    centre.y += speed.y;
    speed.y += gravity.y;
    headCentre = new PVector(centre.x, centre.y - 20);
    shoulders = new PVector(centre.x, centre.y - 15);
    rightHand = new PVector(centre.x + 10, centre.y - 20);
    leftHand = new PVector(centre.x - 10, centre.y - 20);
    rightFoot = new PVector(centre.x + 10, centre.y + 20);
    leftFoot = new PVector(centre.x - 10, centre.y + 20);


    if (centre.y > 380) {
      speed.y = 0;
    }
    if (centre.x > 380 || centre.x < 0) {
      speed.x = speed.x * -1;
    }
  }

  void constrainToScreen() {
    if (centre.x >= 380) {
      centre.x = 380;
    }
    if (centre.x <= 20) {
      centre.x = 20;
    }
    if (centre.y >=380) {
      centre.y = 380;
    }
  }
}