//This class is used to control the emimies you will face in the game.
//Three enimies will appear on the screen and move around randomly.
//If the player can shoot an enemy they will gain 100 points.
//There are three enemies: one starts on the left, the middle, and the right.

class BadGuys {

  //Variables which will be used to calculate the position of enemies.

  float enemyShipX;
  float enemyShipY;

  //These arrays are used to store location data for each of the three enemies.

  float xCoordinate [] = new float[3];
  float yCoordinate [] = new float[3];

  //This PVector is used to calculate the position for each enemy.

  PVector square = new PVector(100, 100);

  BadGuys() {

    //These 'if' statements are used to set the values of the coordinates for each enemy which are stored two seperate arrays.

    //X Coordinates.

    int i = 0;
    while (i < 3) {
      xCoordinate[i] = square.x * (i +1);
      i = i + 1;
    }

    //Y Coordinates.

    int a = 0;
    while (a < 3) {
      yCoordinate[a] = square.y;
      a = a + 1;
    }
  }


  //This Variable is used to draw each of the enemies on the screen.

  void drawEnemy1() {

    //Enemy on the left.

    rect(xCoordinate[0] - 15, yCoordinate[0] - 15, xCoordinate[0] + 15, yCoordinate[0] + 15);

    //enemy in the middle.

    rect(xCoordinate[1] - 15, yCoordinate[1] - 15, xCoordinate[1] + 15, yCoordinate[1] + 15);

    //enemy on the right.

    rect(xCoordinate[2] - 15, yCoordinate[2] - 15, xCoordinate[2] + 15, yCoordinate[2] + 15);
  }

  //This function is used to move the enemies randomly around the screen.
  //Each enemy will move at a different speed and is coloured randomly each cycle.

  void moveEnemy() {

    //Variables used for assigning random values.

    int randomMovement1 = int(random(0, 5));
    int randomMovement2 = int(random(0, 5));
    int randomMovement3 = int(random(0, 5));

    //Enemy on the left.

    fill (randomMovement1 * 20, randomMovement2 * 20, randomMovement3 * 20);
    if (randomMovement1 == 1) {
      xCoordinate[0] = xCoordinate[0] + 10;
    } else if  (randomMovement1 == 2) {
      xCoordinate[0] = xCoordinate[0] - 10;
    } else if  (randomMovement1 == 3) {
      yCoordinate[0] = yCoordinate[0] + 10;
    } else if  (randomMovement1 == 4) {
      yCoordinate[0] = yCoordinate[0] - 10;
    }

    //enemy in the middle.


    fill (randomMovement3 * 20, randomMovement1 * 20, randomMovement2 * 20);
    if (randomMovement2 == 1) {
      xCoordinate[1] = xCoordinate[1] + 12;
    } else if  (randomMovement2 == 2) {
      xCoordinate[1] = xCoordinate[1] - 12;
    } else if  (randomMovement2 == 3) {
      yCoordinate[1] = yCoordinate[1] + 12;
    } else if  (randomMovement2 == 4) {
      yCoordinate[1] = yCoordinate[1] - 12;
    }

    //enemy on the right.

    fill (randomMovement2 * 20, randomMovement3 * 20, randomMovement1 * 20);
    if (randomMovement3 == 1) {
      xCoordinate[2] = xCoordinate[2] + 8;
    } else if  (randomMovement3 == 2) {
      xCoordinate[2] = xCoordinate[2] - 8;
    } else if  (randomMovement3 == 3) {
      yCoordinate[2] = yCoordinate[2] + 8;
    } else if  (randomMovement3 == 4) {
      yCoordinate[2] = yCoordinate[2] - 8;
    }
  }

  //This function is used to check the boundries for each enemy.
  //This makes it so the enemies cannot go offscreen.

  void enemyBoundaries() {

    //Boundaries for enemy on the left.

    if (xCoordinate[0] <= 0 + 15) {
      xCoordinate[0] = 0 + 15;
    }
    if (xCoordinate[0] >= 400 - 15) {
      xCoordinate[0] = 400 - 15;
    }
    if (yCoordinate[0] <= 0 + 15) {
      yCoordinate[0] = 0 + 15;
    }
    if (yCoordinate[0] >= 400 - 15) {
      yCoordinate[0] = 400 - 15;
    }

    //Boundaries for enemy in the middle.

    if (xCoordinate[1] <= 0 + 15) {
      xCoordinate[1] = 0 + 15;
    }
    if (xCoordinate[1] >= 400 - 15) {
      xCoordinate[1] = 400 - 15;
    }
    if (yCoordinate[1] <= 0 + 15) {
      yCoordinate[1] = 0 + 15;
    }
    if (yCoordinate[1] >= 400 - 15) {
      yCoordinate[1] = 400 - 15;
    }

    //Boundaries for enemy on the left.

    if (xCoordinate[2] <= 0 + 15) {
      xCoordinate[2] = 0 + 15;
    }
    if (xCoordinate[2] >= 400 - 15) {
      xCoordinate[2] = 400 - 15;
    }
    if (yCoordinate[2] <= 0 + 15) {
      yCoordinate[2] = 0 + 15;
    }
    if (yCoordinate[2] >= 400 - 15) {
      yCoordinate[2] = 400 - 15;
    }
  }

  //This function is used to check if a bullet the player fired has hit an enemy.
  //This is accomplished by checking if the billet is in the same space as an enemy.
  //If the bullet has hit an enemy the screen will flash a specific colour for each enemy and the player gains 100 points.

  //Enemy on the left.

  void enemyCollision() {
    if (bulletY - 20 <= yCoordinate[0] + 15 && bulletY - 20 >= yCoordinate[0] - 15 && (bulletX - 5 >= xCoordinate[0] - 15 || bulletX + 5 >= xCoordinate[0] - 15) && (bulletX - 5 <= xCoordinate[0] + 15 || bulletX + 5 <= xCoordinate[0] + 15)) {
      background(50, 0, 0);
      points = true;
    }

    //Enemy in the middle.

    if (bulletY - 20 <= yCoordinate[1] + 15 && bulletY - 20 >= yCoordinate[1] - 15 && (bulletX - 5 >= xCoordinate[1] - 15 || bulletX + 5 >= xCoordinate[1] - 15) && (bulletX - 5 <= xCoordinate[1] + 15 || bulletX + 5 <= xCoordinate[1] + 15)) {
      background(0, 50, 0);
      points = true;
    }

    //Enemy on the right.

    if (bulletY - 20 <= yCoordinate[2] + 15 && bulletY - 20 >= yCoordinate[2] - 15 && (bulletX - 5 >= xCoordinate[2] - 15 || bulletX + 5 >= xCoordinate[2] - 15) && (bulletX - 5 <= xCoordinate[2] + 15 || bulletX + 5 <= xCoordinate[2] + 15)) {
      background(0, 0, 50);
      points = true;
    }
  }
}