//This class is used to control the movement, firing and hit detection of the ship.
// The ship can move in 8 directions using WASD and fires a bullet when the player presses the spacebar.
//If the player hits an enemy with a bullet the scrren will flash and they get 100 points.
//The player cannot leave the boundaries of the screen.

//Varibles for the location of the bullet the player fires.
//I did not place these inside the class as I needed to use these variables in other parts of the program.

float bulletX;
float bulletY;

class Ship {

  //Variables which will be used to calculate the position of the ship and the bullets the ship fires.

  float shipX;
  float shipY;
  boolean bulletFired = false;

  //These variables are the cooldown for firing your ship's gun.

  int cooldown = 0;
  boolean cooldownBar = false;
  int cooldownBarLength = 0;

  //This boolean array is used to determine what keys are currently being pressed.
  //This array hold information for keys 'w', 's', 'a', 'd' and the spacebar.
  //***I got the idea for using a boolean array to press multiple keys at the same time from user JohnG who posted this information on the processing.org forum.***

  boolean[] actionKeys = new boolean[5];

  //Constructor for the ship class.

  Ship(float tempShipX, float tempShipY, float tempBulletX, float tempBulletY) {
    shipX = tempShipX;
    shipY = tempShipY;
    bulletX = tempBulletX;
    bulletY = tempBulletY;
  }

  //This sets all of the 'actionKeys' array variables to 'false' during the setup of the program.

  void setupShip() {

    //***I got the idea for using a while statement to complete comlete this task instead of indavidually listing each variable from Daniel Schiffman's book 'Learning Processing'.

    int i = 0;
    while (i < 5) {
      actionKeys[i] = false;
      i = i + 1;
    }
  }

  //Checks to see if any of the keys which cause the ship to move are being pressed.
  //If this is the case, the boolean valuse for that key will be set to true.
  //***I got the idea for using a boolean array to press multiple keys at the same time from user JohnG who posted this information on the processing.org forum.***

  void isShipMoving() { 

    //Checks if 'a' key is pressed.

    if (key == 'a') {
      actionKeys[0] = true;
    }

    //Checks if 'd' key is pressed.

    if (key == 'd') {
      actionKeys[1] = true;
    }

    //Checks if 'w' key is pressed.

    if (key == 'w') {
      actionKeys[2] = true;
    }

    //Checks if 's' key is pressed.

    if (key == 's') {
      actionKeys[3] = true;
    }

    //Checks if spacebar is pressed.

    if (key == ' ') {
      actionKeys[4] = true;
    }
  }

  //Checks to see if any of the keys which cause the ship to move are have been released.
  //If this is the case, the boolean valuse for that key will be set to false.
  //***I got the idea for using a boolean array to press multiple keys at the same time from user JohnG who posted this information on the processing.org forum.***

  void isShipStopping() {

    //Checks if 'a' key is released.

    if (key == 'a') {
      actionKeys[0] = false;
    }

    //Checks if 'd' key is released.

    if (key == 'd') {
      actionKeys[1] = false;
    }

    //Checks if 'w' key is released.

    if (key == 'w') {
      actionKeys[2] = false;
    }

    //Checks if 's' key is released.

    if (key == 's') {
      actionKeys[3] = false;
    }

    //Checks if spacebar is released.

    if (key == ' ') {
      actionKeys[4] = false;
    }
  }

  //If a key is being pressed to move the ship, this function will move the ship in that direction until the key is released.

  void moveShip() {

    //Moves ship left.

    if (actionKeys[0] == true) {
      shipX = shipX - 4;
    }

    //Moves ship right.

    if (actionKeys[1] == true) {
      shipX = shipX + 4;
    }

    //Moves ship up.

    if (actionKeys[2] == true) {
      shipY = shipY - 4;
    }

    //Moves ship down.

    if (actionKeys[3] == true) {
      shipY = shipY + 4;
    }
  }

  //If the spacebar had been pressed, the ship will fire a bullet. 
  //If the spacebar is held down the ship will fire a bullet every time the 'bulletcooldown' variable reaches zero.

  void fireShip() {

    //if the spacebar is pressed this statement will start the process of firing a bullet.

    if (actionKeys[4] == true && cooldown <= 0) {
      bulletFired = true;

      //This makes sure the bullet is shot from the location of the ship.

      bulletX = shipX;
      bulletY = shipY;

      //This cooldown stops the player from firing another bullet.

      cooldown = 140;
      cooldownBar = true;
    }

    //This statement actually draws the bullet and moves it upward. It also decreases the 'bulletcooldown' variable so another bullet can be shot.  

    if (bulletFired == true) {
      fill(232, 141, 12);
      rect(bulletX - 5, bulletY - 20, bulletX + 5, bulletY - 30);
      bulletY = bulletY - 6;
      cooldown = cooldown - 2;
    }
  }

  //This function is used to display a bar on the screen which shows the player how long they have to wait before they fire a bullet.

  void bulletCooldownTimer() { 

    //When the player fires a bullet a bar appears on the bottom of the screen which will slowly shrink until there is no bar left.
    //This lets the player know they can now fire another bullet.

    if (cooldownBar == true) {
      fill(200, 20, 20);
      rect(400 - cooldown * 3, 380, 400, 390);
    }

    if (cooldown <= 0) {
      cooldownBar = false;
    }
  }

  //This function is used to make sure the ship that the player controls cannot leave the sceen.
  //If the player gets to an edge on the scrren they will not be able to move surther in that direction.

  void shipBoundaries() {

    //Boundaries for the left of the screen.

    if (shipX <= 0 + 20) {
      shipX = 0 + 20;
    }

    //Boundaries for the right of the screen.

    if (shipX >= 0 + 380) {
      shipX = 0 + 380;
    }

    //Boundaries for the top of the screen.

    if (shipY <= 0 + 20) {
      shipY = 0 + 20;
    }

    //Boundaries for the bottom of the screen.

    if (shipY >= 0 + 380) {
      shipY = 0 + 380;
    }
  }

  //Draws the ship after all of the movements have been made. 

  void drawShip() {
    fill(40, 40, 120);
    triangle(shipX - 20, shipY + 20, shipX + 20, shipY + 20, shipX, shipY - 20);
  }
}