/*
Assignment #3 - OBJECT ORIENTED TOY
 "SPACE BATTLE"
 Created by Eric James
 October 20, 2016
 
 In this program you control a spaceship which can move in 8 directions using the WASD keys.
 Three enemies will be moving around the screen which you can shoot.
 You fire bullets from your spaceship by pressing the spacebar.
 The goal of the game is to get as many points as possible.
 Every time the player hits a square they will receive 100 points.
 Try to go for a high score!
 */

//This declares all objects used in the program as global variables.

Ship spaceShip;
BadGuys enemies;

void setup() {

  //initializes the objects used in the program.

  spaceShip = new Ship(200, 300, 200, 300);
  enemies = new BadGuys();


  //Initial setup of the window size and framerate.

  size(400, 400);
  frameRate(60);

  //Setup of some functions which are called from other classes.

  spaceShip.setupShip();
}

void draw() {

  //Draws a constantly refreshing backround.

  background(0);

  //Will not draw lines around objects

  noStroke();

  //Rectangles are drawn in corner mode.

  rectMode(CORNERS);

  //Calculates where the emeny will move.

  enemies.moveEnemy();

  //checks the boundaries of the enemies.

  enemies.enemyBoundaries();

  //checks the collision for if a bullet is hitting an enemy.

  enemies.enemyCollision();

  //Draws the enemies on the screen.

  enemies.drawEnemy1();

  //This function is used to draw the bar which shows the player how long it will be before they can fire their gun again.

  spaceShip.bulletCooldownTimer();

  //These functions are used to calculate where the ship will move and then draws the ship on the screen.
  //'shipBoundaries' is used to make sure the ship does not go off screen.

  spaceShip.moveShip();
  spaceShip.shipBoundaries();
  spaceShip.drawShip();

  //This function is used to fire the gun on the ship.

  spaceShip.fireShip();
}

void keyPressed() {

  //Used to determine which keys are currently being pressed.

  spaceShip.isShipMoving();
}

void keyReleased() {

  //Used to determine which keys have now been released.

  spaceShip.isShipStopping();

  //This is used to keep track of the player's score.

  scoreTracker();
} 