/* 
 See how good of a Captain you are! Avoid space debris,
 survive as long as you can. Your score is based on 
 how long you can pilot the ship without smashing into
 oncoming debris while speeding through space!
 -------------------------------------------------------
 An Object Based Toy Created by: Harry Pitts
 */

//Global Variables
int seconds = millis();
int numberOfSpaceRocks = 40;

//Space Debris array
Debris[] debris = new Debris[numberOfSpaceRocks];

//Initializing Classes
ScoreBoard scoreBoard;
Player player1;

void setup() {
  
  size(600, 600);
  background(7, 7, 7);
  smooth();
  rectMode(CORNERS);
  scoreBoard = new ScoreBoard();
  player1 = new Player();
  initializeDebris();
}

void initializeDebris() {

  for (int i = 0; i < debris.length; i++) {
    debris[i]=new Debris(random(3, width), 0, random(-2, 5), random(1, 3));
  }
}
void draw() {

  //background update
  background(7, 7, 7);
  //Calling classes
  scoreBoard.displayScore();
  player1.playerDisplay();

  for (int i = 0; i < debris.length; i++) {
    debris[i].debrisCollision();
    debris[i].debrisUpdate();
    debris[i].debrisDisplay();
  }
}