// Global Variables
int[] xPositionsR = new int[numberOfBullets]; 
int[] xPositionsL = new int[numberOfBullets]; 
int[] yPositionsR = new int[numberOfBullets]; 
int[] yPositionsL = new int[numberOfBullets]; 
float[] distances = new float[numberOfBullets];
boolean[] bulletExists = new boolean[numberOfBullets];
int bulletCount = 0;


// Create the class
class GoodProjectiles {

  // Initialize the class
  void initialize() {

    for (int count = 0; count < bulletExists.length; count++) {
      xPositionsR[count] = int(playerPosition.x) + 15;
      yPositionsR[count] = int(playerPosition.y) + 5;
      xPositionsL[count] = int(playerPosition.x) - 15;
      yPositionsL[count] = int(playerPosition.y) + 5;
      distances[count] = 0;
      bulletExists[count] = false;
    }
  }

  // Update the values
  void update() {
    updateReadyShot();
    updateCurrentBullets();
  }

  // Display the stuff
  void display() {
    drawShots();
  }
}



// Declare internal functions

// Draw the existing bullets
void drawShots() {

  noStroke();
  fill(0, 0, 99);

  for (int count = 0; count < bulletExists.length; count++) {
    if (bulletExists[count] == true) {
      ellipse(xPositionsR[count], yPositionsR[count], 5, 8);
      ellipse(xPositionsL[count], yPositionsL[count], 5, 8);
    }
  }
}

// Update the non-existant bullet positions
void updateReadyShot() {
  for (int count = 0; count < bulletExists.length; count++) {
    if (bulletExists[count] == false) {
      xPositionsR[count] = int(playerPosition.x) + 10;
      yPositionsR[count] = int(playerPosition.y) - 5;
      xPositionsL[count] = int(playerPosition.x) - 10;
      yPositionsL[count] = int(playerPosition.y) - 5;
    }
  }
}

// Update the existing bullets & remove off screen ones
void updateCurrentBullets() {
  for (int count = 0; count < bulletExists.length; count++) {

    if (bulletExists[count] == true) {
      yPositionsR[count] = yPositionsR[count] - 6;
      yPositionsL[count] = yPositionsL[count] - 6;
      if (yPositionsR[count] <= 0 || yPositionsL[count] <= 0) {
        bulletExists[count] = false;
      }
    }
  }
}