/*---------------------------------------------+
 | Filename: cheese_defender                   |
 | By: Diane "Iya" Downey                      |
 | You must defend the tasty cheese dimension  | 
 | from the invading germs! Use your trusty    |
 | salt cannons to defeat them with SPACEBAR!  |
 +--------------------------------------------*/

// Global Variables
int numberOfGreeblies = 10;
int numberOfBullets = 20;
boolean canPlay = false;
Player player;
GoodProjectiles goodProjectiles;
Greeblies[] allTheGreeblies = new Greeblies[numberOfGreeblies];

color buttonStrokeColor;
color buttonFillColor;

// Setup
void setup() {
  // Set up the canvas & frame rate
  size(800, 600);
  frameRate(60);

  // Adjust the Colors & Shape Modes
  colorMode(HSB, 360, 100, 100);
  buttonStrokeColor = color(#404040);
  buttonFillColor = color(#818181);
  ellipseMode(CENTER);
  rectMode(CENTER);
  smooth();

  // Intialize All Objects
  intializeObjects();
}


// When they click the mouse...
void mousePressed() {
  if (canPlay == false) {
    // Check if the mouse is over the button
    if (mouseX < width/2+100 && mouseX > width/2-100 && mouseY < height-150+50 && mouseY > height-150-50) {
      // Button pressing animation
      buttonStrokeColor = color(#818181);
      buttonFillColor = color(#404040);
      drawStartButton();
    } else { 
      buttonStrokeColor = color(#404040);
      buttonFillColor = color(#818181);
    }
  }
}


// When they let go of the mouse...
void mouseClicked() {
  if (canPlay == false) {
    // Check if the mouse is over the button
    if (mouseX < width/2+100 && mouseX > width/2-100 && mouseY < height-150+50 && mouseY > height-150-50) {
      // Turn on the game!
      canPlay = true;
    }
  }
}


// Draw stuff
void draw() {

  // Diplay the start menu
  if (canPlay == false) {

    // DISPLAY the start menu
    drawStartMenu();
  }

  if (canPlay == true) {

    // UPDATE game objects
    updateGameObjects();

    // DISPLAY game objects
    displayGameObjects();
  }
}


// Declare Functions

// Intialize ALL objects
void intializeObjects() {

  player = new Player();
  player.initialize();

  goodProjectiles = new GoodProjectiles();
  goodProjectiles.initialize();

  createAllTheGreeblies();
}

// All the update commands for the game
void updateGameObjects() {

  player.update();
  goodProjectiles.update();
  for (int count = 0; count < allTheGreeblies.length; count++) {
    allTheGreeblies[count].update();
  }

  
}

// All the display for the game
void displayGameObjects() {

  drawBackground();
  player.display();
  goodProjectiles.display();
  for (int count = 0; count < allTheGreeblies.length; count++) {
    allTheGreeblies[count].display();
  }
}


// Creation command for baddies
void createAllTheGreeblies() {
  for (int count = 0; count < allTheGreeblies.length; count++) {
    allTheGreeblies[count] = new Greeblies();
  }
  for (int count = 0; count < allTheGreeblies.length; count++) {
    allTheGreeblies[count].initialize();
  }
}


// Draw the start menu
void drawStartMenu() {
  background(0, 0, 0);
  drawLogo();
  drawInstructions();
  drawStartButton();
}


// Draw the Logo
void drawLogo() {

  strokeWeight (3);
  stroke(43, 82, 90);
  fill(47, 82, 95);
  //C
  arc(100, 100, 100, 100, radians(45), radians(315), PIE);
  fill(43, 82, 90);
  ellipse(70, 90, 10, 10);
  ellipse(100, 70, 15, 15);
  ellipse(90, 125, 20, 20);
  // H
  fill(47, 82, 95);
  triangle(150, 50, 170, 50, 150, 150);
  triangle(155, 145, 180, 100, 190, 110);
  triangle(190, 110, 200, 145, 180, 120);
  // EE
  arc(230, 125, 50, 50, radians(70), radians(360), PIE);
  arc(290, 125, 50, 50, radians(70), radians(360), PIE);
  fill(43, 82, 90);
  ellipse(230, 113, 15, 10);
  ellipse(220, 135, 10, 10);
  ellipse(290, 113, 15, 10);
  ellipse(275, 130, 10, 10);
  // S
  fill(47, 82, 95);
  arc(340, 130, 40, 40, radians(-90), radians(140), PIE);
  arc(340, 110, 40, 40, radians(90), radians(320), PIE);
  // E
  arc(395, 125, 50, 50, radians(70), radians(360), PIE);
  fill(43, 82, 90);
  ellipse(395, 113, 15, 10);
  ellipse(385, 135, 10, 10);
  // Defender
  textAlign(LEFT, TOP);
  textSize(75);
  text("Defender", 400, 150);
}


// Draw instructions
void drawInstructions() {
  stroke(color(#404040));
  fill(color(#818181));
  rect(125, 500, 150, 30, 25);
  textAlign(CENTER, CENTER);
  textSize(12);
  text("Fire!", 125, 475);
}


// Draw the start button
void drawStartButton() {
  textAlign(CENTER, CENTER);
  textSize(40);
  strokeWeight(4);
  stroke(buttonStrokeColor);
  fill(buttonFillColor);
  rect(width/2, height-150, 200, 100);
  strokeWeight(3);
  line(300, 400, 315, 415);
  line(300, 500, 315, 485);
  line(500, 400, 485, 415);
  line(500, 500, 485, 485);
  strokeWeight(4);
  rect(width/2, height-150, 170, 70);
  fill(buttonStrokeColor);
  text("START", width/2, height-153);
}


// Draw the game's background
void drawBackground() {

  background(47, 82, 95);
  noStroke();
  fill(43, 82, 90);
  ellipse(100, 100, 200, 200);
  ellipse(300, 150, 100, 100);
  ellipse(100, 400, 100, 100);
  ellipse(325, 450, 100, 200);
  ellipse(550, 350, 150, 150);
  ellipse(125, 570, 300, 150);
  ellipse(500, 50, 275, 175);
  ellipse(700, 100, 100, 200);
  ellipse(700, 500, 200, 150);
  ellipse(790, 300, 200, 150);
  fill(43, 82, 85);
  ellipse(75, 75, 100, 100);
  ellipse(300, 165, 50, 50);
  ellipse(115, 415, 50, 50);
  ellipse(330, 490, 50, 100);
  ellipse(525, 360, 75, 75);
  ellipse(150, 565, 150, 75);
  ellipse(525, 40, 150, 100);
  ellipse(690, 125, 50, 100);
  ellipse(675, 525, 100, 75);
  ellipse(790, 275, 100, 75);
}