/******************************************************************
 *File Name: Simon_Says
 *Author: Jacob Estrella
 *Date: October 20, 2016
 *Description: An interactive toy using objects and classes.
 *Players respond to a generated pattern and try to match the color
 *displayed on screen. A light tells them if they are correct or not
 ******************************************************************/

//Class Declaration
PatternGenerator pattern = new PatternGenerator();
PlayerInput input = new PlayerInput();
MatchCheck check = new MatchCheck();

//Global Variable Declaration

//Used to check if the generated pattern and player input match
int [] correctMatch = new int [2];

//Used to check if there is player input before displaying correct/incorrect lights
boolean [] pauseBeforeCheck = new boolean [2];


void setup()
{
  size(400, 400);

  //Rules and directions for player
  playerControls();
  //Initializing global variables to not set off indicator lights
  pauseBeforeCheck [0] = false;
  pauseBeforeCheck [1] = false;
}

void draw()
{
  background(0);

  //Green Button
  fill(0, 255, 0, 170);
  triangle(200, 80, 200, 200, 80, 200);

  //Red Button
  fill(255, 0, 0, 170);
  triangle(200, 80, 200, 200, 320, 200);

  //Yellow Button
  fill(255, 255, 0, 170);
  triangle(80, 200, 200, 200, 200, 320);

  //Blue Button
  fill(0, 0, 255, 170);
  triangle(200, 200, 200, 320, 320, 200);

  //Center Button
  fill(170);
  quad(200, 160, 160, 200, 200, 240, 240, 200);

  //Indicator Light
  fill(255, 0, 0);
  rect(180, 340, 40, 40);
  noFill();

  //After every loop/input, checks if correct to display proper indicator light
  check.playerMatchCheck();
}

void keyPressed()
{
  //Pressing the Spacebar randomizes the color
  if (keyCode == 32)
  {
    frameRate(2);
    pattern.pattern();

    //Sets the generated pattern variable to true
    pauseBeforeCheck [0]= true;
  }

  //Pressing R flashes the Red Button
  if (key == 'r')
  {
    frameRate(2);
    input.buttonRed();

    //Sets the player input variable to true
    pauseBeforeCheck [1]= true;
  }

  //Pressing G flashes the Green Button
  if (key == 'g')
  {
    frameRate(2);
    input.buttonGreen();

    //Sets the player input variable to true
    pauseBeforeCheck [1]= true;
  }

  //Pressing B flashes the Blue Button
  if (key == 'b')
  {
    frameRate(2);
    input.buttonBlue();

    //Sets the player input variable to true
    pauseBeforeCheck [1]= true;
  }

  //Pressing Y flashes the Yellow Button
  if (key == 'y')
  {
    frameRate(2);
    input.buttonYellow();

    //Sets the player input variable to true
    pauseBeforeCheck [1]= true;
  }
}

//Rules and directions of the toy
void playerControls()
{
  println("Press 'Spacebar' to produce a random color");
  println("To match the color, press 'R' for Red, 'B' for Blue, 'Y' for Yellow, and 'G' for Green");
}