class FriendlyGhosts {

  //Declare FriendlyGhost variables
  PVector position = new PVector();
  PVector velocity = new PVector();
  float wide = 50;
  float tall = 70;

  boolean startWidth = true;
  boolean startHeight = true;

  FriendlyGhosts() {
    initialize();
  }

  void initialize() {
    //declare starting ghost values
    //booleans allows ghosts to spawn in all corners
    if (startWidth == true && startHeight == true) {
      position.x=width;
      position.y=height;
      startWidth = false;
    } else if (startWidth == false && startHeight == true) {
      position.x=0;
      position.y=height;
      startHeight = false;
    } else if (startWidth == false && startHeight == false) {
      position.x=0;
      position.y=0;
      startWidth = true;
    } else {
      position.x=width;
      position.y=0;
      startHeight=true;
    }
    velocity.x = random(-5, 10);
    velocity.y = random(-5, 10);
  }

  void display() {
    rectMode(CORNER);
    ellipseMode(CENTER);
    //body
    fill(255, 125);
    rect(position.x, position.y, wide, tall, 10);
    //tail that wiggles
    triangle(position.x + 5, position.y + tall, position.x + wide, position.y + tall, position.x + wide + random(10, 20), position.y + tall + random(10, 20));
    //skull
    fill(255);
    ellipse(position.x + wide/2, position.y + 10, wide-15, wide-15);
    //eyes
    fill(0);
    ellipse(position.x + wide/3, position.y + 10, wide-40, wide-30);
    ellipse(position.x + wide/3*2, position.y + 10, wide-40, wide-30);
    //eye smile
    fill(255);
    rect(position.x+ 10, position.y +15, 30, 5);
    //smile
    fill(0);
    triangle(position.x + wide/2 - 5, position.y +20, position.x + wide/2 + 5, position.y + 20, position.x + wide/2, position.y +25);
  }

  void update() {
    position.add(velocity);

    //if ghost had moved off screen, re-initialise ghost
    if (position.x < -50 || position.y < -50 || position.x > 450 || position.y > 450) {
      initialize();
    }

    //if ghost is shot, decrease score
    if (dist(mouseX, mouseY, position.x, position.y) < 30 && mousePressed) {
      initialize();
      score = score-1;
    }
  }
}