/**
 ** BUST THOSE GHOSTS!
 ** By: Jensen Verlaan
 ** 
 ** It's almost Halloween and the ghosts of the graveyard are running rampant again!
 ** While some are friendly and well behaved, others are acting out and causing mischief around town!
 ** As the local witch doctor, it's up to you to calm these restless spirits!
 ** Shoot the bad spirits with your one-of-a-kind "Witch Doctor Zapper Gun" to return them to a peaceful slumber!
 ** The upper middle score will keep count of how many naughty spirits you send back to their graves!
 ** But watch out!!! Shooting peaceful spirits will lower your score.
 ** Happy hunting and Happy Halloween!!!
 **
 ** This work was inspired by "gone_fishing_oo" by Nicolas Hesler and "Balloon Pop" by Ali O'Conner.
 **/

//Declare objects as global variables
int numberOfGhosts = 10;
int score = 0;

FriendlyGhosts[] friendlyGhosts = new FriendlyGhosts[numberOfGhosts];
EvilGhosts[] evilGhosts = new EvilGhosts[numberOfGhosts];

Tombstone[] grave1 = new Tombstone[3];
Tombstone[] grave2 = new Tombstone[4];
Tombstone[] grave3 = new Tombstone[5];

void setup() {
  //Set canvas size to 400 x 400 pixels
  size(400, 400);
  //set frame rate to 60
  frameRate(60);
  noStroke();
  noCursor();

  //Initialize objects in setup() by calling constructor
  createFriendlyGhosts();
  createEvilGhosts();

  //hardcode locations values into each tombstone
  grave1[0] = new Tombstone(20, 220, 40, 70);
  grave1[1] = new Tombstone(160, 220, 40, 70);
  grave1[2] = new Tombstone(320, 220, 40, 70);

  grave2[0] = new Tombstone(-30, 150, 30, 40);
  grave2[1] = new Tombstone(100, 150, 30, 40);
  grave2[2] = new Tombstone(240, 150, 30, 40);
  grave2[3] = new Tombstone(380, 150, 30, 40);

  grave3[0] = new Tombstone(-20, 100, 20, 30);
  grave3[1] = new Tombstone(80, 100, 20, 30);
  grave3[2] = new Tombstone(180, 100, 20, 30);
  grave3[3] = new Tombstone(280, 100, 20, 30);
  grave3[4] = new Tombstone(380, 100, 20, 30);
}

//Add a number value to each Evil Ghost in the array from 0 - 19
void createEvilGhosts() {
  for (int i = 0; i < evilGhosts.length; i++) {
    evilGhosts[i] = new EvilGhosts();
  }
}

//Add a number value to each Friendly Ghost in the array from 0 - 19
void createFriendlyGhosts() {
  for (int i = 0; i < friendlyGhosts.length; i++) {
    friendlyGhosts[i] = new FriendlyGhosts();
  }
}

void draw() {

  ////////////////
  /////UPDATE/////
  ////////////////

  //update FriendlyGhosts
  for (int i = 0; i < friendlyGhosts.length; i++) {
    friendlyGhosts[i].update();
  }
  //updateEvilGhosts
  for (int i = 0; i < evilGhosts.length; i++) {
    evilGhosts[i].update();
  }

  /////////////////
  /////DISPLAY/////
  /////////////////

  background(0);
  //Draw the background
  setting();
  //Draw the tombstones
  for (int i = 0; i < grave1.length; i++) {
    grave1[i].display();
  }
  for (int i = 0; i < grave2.length; i++) {
    grave2[i].display();
  }
  for (int i = 0; i < grave3.length; i++) {
    grave3[i].display();
  }
  //Draw single cross grave
  singleCrossGrave();

  //display Friendly Ghosts
  for (int i = 0; i < friendlyGhosts.length; i++) {
    friendlyGhosts[i].display();
  }
  //display evil ghosts
  for (int i = 0; i < evilGhosts.length; i++) {
    evilGhosts[i].display();
  }
  aimingReticle();

  //display the score
  updateScore();
}

////////////////////////////
/////SINGLE CROSS GRAVE/////
////////////////////////////

//for the aesthetic
void singleCrossGrave() {
  fill(75);
  rect(180, 70, 30, 60, 7);
  rect(170, 80, 50, 20, 7);
  fill(125);
  rect(180, 70, 20, 60, 7);
  rect(170, 80, 40, 20, 7);
}

////////////////////
/////BACKGROUND/////
////////////////////

//Draw the background
void setting() {
  noStroke();
  fill(48, 53, 30);
  rect(0, 125, width, height);
  fill(84, 92, 61);
  rect(0, 185, width, height);
  fill(87, 103, 72);
  rect(0, 280, width, height);
}

//////////////////////
///AIMING RETICLE/////
//////////////////////

//Create Crosshairs that follow the cursor's location
void aimingReticle() {
  noFill();
  stroke(100, 200, 100);
  strokeWeight(3);
  ellipse(mouseX, mouseY, 30, 30);
  line(mouseX -  20, mouseY, mouseX -10, mouseY);
  line(mouseX + 20, mouseY, mouseX + 10, mouseY);
  line(mouseX, mouseY + 20, mouseX, mouseY +10);
  line(mouseX, mouseY - 20, mouseX, mouseY - 10);
  fill(255, 100, 100);
  stroke(100, 200, 100);
  strokeWeight(5);
  point(mouseX, mouseY);
}

///////////////
/////SCORE/////
///////////////

//Create a score that will display in the upper middle of the canvas
void updateScore() {
  fill(255);
  textSize(32);
  text(score, width/2, height/10);
}