class Creature { //<>//

  PVector position;
  PVector velocity;

  PVector randomDirection; 
  PVector directionToFood;
  float speed;

  int faceSize; 
  int eyeSize; 
  color eyeColor;


  // constructor - starting values for position, speed, size, and color
  
  Creature(float positionX, float positionY, float creatureSpeed) {
    position = new PVector(positionX, positionY);
    speed = creatureSpeed;

    faceSize = 20;
    eyeSize = 5;
    eyeColor = color(255, 255, 255);

    randomDirection= new PVector(random(0, 600), random(0, 500));
  }

  void update() {

    // when there's no food onscreen
    if (speck.eaten) {   
      
      // creatures bounce off edges
      
      if ((position.x > width) || (position.x < 0)) {
        randomDirection.x = randomDirection.x * -1;
      }

      if ((position.y > height) || (position.y < 0)) {
        randomDirection.y = randomDirection.y * -1;
      }
      // creatures move in a random direction
      directionToFood=randomDirection;
    } 
    
    // when there IS food on the screen
    else {
      
      // so creatures can locate food position 
      PVector foodPosition = new PVector(speck.foodPositionX, speck.foodPositionY);
      
      // creatures move toward food 
      directionToFood = PVector.sub(foodPosition, position);

      /* if distance b/n food and creature is small enough
      i.e. (creature is touching the food)
      then food is eaten */

      if (abs(speck.foodPositionX - position.x) < 2 && (abs(speck.foodPositionY - position.y) < 5)) {
        speck.eaten = true;
        
        // eye color changes 
        eyeColor = color(255, 150, 0); 
        
        // creature size will increase with food intake, up to 50
        if (faceSize < 50) {
          faceSize = faceSize + 1;
        }
      }
    }
    
    directionToFood.normalize(); 
    velocity = PVector.mult(directionToFood, speed); 
    position.add(velocity);
    
  }

  void display() {
    
    // creature face
    fill(0); 
    ellipse(position.x, position.y, faceSize, faceSize);
    
    //creature eyes 
    fill(eyeColor);
    ellipse(position.x + 5, position.y, eyeSize, eyeSize);
    ellipse(position.x - 5, position.y, eyeSize, eyeSize);
  }
}