class Bird {
  //bird variables
  PVector position = new PVector();
  PVector velocity = new PVector();
  color birdColor;

  Bird() {
    initial();
  }

  //reference: gone fishing
  void initial() {
    //set initial bird values
    position.x = width+random(0, 100);
    position.y = random(0, height);
    velocity.x = random(-10, -0.5);
    birdColor = color(random(50, 200), random(50, 200), random(50, 200));
  }

  void update() {
  //move bird from right to left
  position.add(velocity);

  //if bird is off screen, reset bird
  if (position.x<-100) {
    initial();
  }
  //if mouse is over bird when mousepressed, reset bird
  if (mousePressed && mouseX > position.x && mouseX < position.x+150 && mouseY > position.y-50 && mouseY < position.y+30) {
    initial();
  }
  }
  
  void display() {
    stroke(0);
    strokeWeight(1);
    fill(birdColor);
    //beak
    triangle(position.x, position.y, position.x+20, position.y-10, position.x+20, position.y+10);
    //tail
    triangle(position.x+70, position.y+10, position.x+150, position.y-10, position.x+120, position.y+20);
    //back wing
    triangle(position.x+50, position.y, position.x+60, position.y-60, position.x+70, position.y-10);
    //body
    ellipse(position.x+70, position.y+5, 30, 25);
    //head
    ellipse(position.x+30, position.y, 20, 20);
    //front wing
    triangle(position.x+50, position.y, position.x+110, position.y-60, position.x+110, position.y-10);
    //eye
    fill(255);
    ellipse(position.x+30, position.y, 10, 10);
    fill(0);
    ellipse(position.x+30, position.y, 2, 2);
  }
}