/*
Title: Bird Shooter
By: Zhe Yue
Click on birds to shoot them
*/

//Bird array
Bird[] birds = new Bird[10];

//Crosshair object
Crosshair crosshair;

void setup() {
  noCursor();
  size(600, 600);
  smooth();
  rectMode(CORNERS);
  ellipseMode(RADIUS);

  //Initialize birds
  for (int i=0; i<birds.length; i++) {
    birds[i]= new Bird();
  }

  //Initialize crosshair
  crosshair = new Crosshair();
}

void draw() {
  frameRate(60);
  noStroke();
  background(171, 188, 230);
  drawClouds();

  //draw and move birds, reset if bird goes off screen or is clicked on
  for (int i=0; i<birds.length; i++) {
    birds[i].update();
    birds[i].display();
  }

  //draw crosshair at mouse coordinates
  crosshair.display(mouseX, mouseY);
}

void drawClouds() {
  //draw clouds
  fill(234, 234, 234);
  ellipse(65, 280, 70, 60);
  ellipse(155, 330, 50, 50);
  ellipse(230, 330, 40, 50);
  ellipse(260, 410, 50, 50);
  ellipse(310, 450, 30, 40);
  triangle(250, 430, 250, 500, 400, 500);
  rect(0, 300, 250, 500);

  ellipse(570, 100, 40, 40);
  ellipse(550, 170, 30, 50);
  ellipse(510, 210, 40, 40);
  triangle(420, 250, 540, 250, 540, 190);
  rect(540, 100, 600, 250);
}