class Character 
{
  // x and y coordinates
  PVector location;
  // x and y speed
  PVector velocity;
  float ground;
  float gravity;
  float jumpHeight;
  float moveSpeed;
  float maxFallSpeed;
  float HP;
  boolean moveLeft;
  boolean moveRight;
  boolean jump;
  boolean grounded;
  boolean Alive;
  int facingRight;
  int lookingRight;

  Character() 
  {
    gravity = 0.1;
    ground = 350;
    jumpHeight = 3.5;
    moveSpeed = 3;
    maxFallSpeed = 10;
    moveLeft = false;
    moveRight = false;
    jump = false;
    grounded = true;
    facingRight = 1;
    lookingRight = 1;
    HP = 100;
    Alive = true;

    location = new PVector (100, 350);
    // X speed and Y speed
    velocity = new PVector (moveSpeed, 2);
  }

  void movement() 
  {
    // Make the character recieve gravity when he is not on the ground
    if (grounded == false) 
    {
      // gravity on the character
      location.y += velocity.y;
      velocity.y += gravity;
      // falling speed cap
      if (velocity.y > maxFallSpeed)
      {
        velocity.y = maxFallSpeed;
      }
    } else
    {
      //reset character y velocity
      velocity.y = 0;
    }

    // Make the character move when 'w' 'a' or 'd' are pressed
    if (moveLeft == true) 
    {
      location.x -= moveSpeed;
      moveLeft = false;
    } else if (moveRight == true) 
    {
      location.x += moveSpeed;
      moveRight = false;
    } 
    if (jump == true && (grounded == false)) 
    {

      location.y -= jumpHeight;
      jump = false;
    }
  }




  void Health() {
    if (Alive) {
      fill (255, 0, 0);
      rect(location.x-40, location.y - 150, location.x-40 + HP, location.y - 140);
    }
    if (!darkKnight.Dead) {
      if (darkKnight.Position.x < location.x + 20 && darkKnight.Position.x > location.x - 20 && location.y > 340) {
        HP -= 1;
      }
    }
    if (HP < 1)
    {
      HP = 0;
      Alive = false;
    }
  }





  void keyPressed() 
  {
    // player moves left and right when a and d are pressed
    if (keyPressed) 
    {
      if ((key == 'a') || (key == 'A')) 
      {
        moveLeft = true;
        facingRight = 0;
      } else if ((key == 'd') || (key == 'D')) 
      {
        moveRight = true;
        facingRight = 1;
      }
      // Make character jump
      if ((key == 'w') || (key == 'W')) 
      {
        jump = true;
        grounded = false;
      }
    }
  }





  void keyReleased() 
  {
    if ((key == 'a') || (key == 'A')) 
    {
      moveLeft = false;
    } else if ((key == 'd') || (key == 'D')) 
    {
      moveRight = false;
    } else if ((key == 'w') || (key == 'W')) 
    {
      jump = false;
    }
  }


  void checkForCollisionVsPlatform()
  {
    //println((location.y <= platform.bottom+10), (location.y >= platform.top-10), (location.x >= platform.left), (location.x <= platform.right));



    if ((location.y <= platform.bottom+10) && (location.y >= platform.top-10) && (location.x >= platform.left) && (location.x <= platform.right))
    {
      grounded = true;
      location.y = platform.top - 10;
      //println("Grounded");
    } else if (((location.x < platform.left) && (location.y < ground - 10)) || ((location.x > platform.right) && (location.y < ground - 10)))
    {
      grounded = false;
    }
    stroke(255, 0, 0);
    point(location.x, location.y);
  }

  void border() 
  {
    // ground
    if (location.y >= 350)
    {
      grounded = true;
    }
    if (location.x < 0) 
    {
      location.x = 0;
    } else if (location.x > width - 10) 
    {
      location.x = width - 10;
    } else if (location.y > ground)
    {
      location.y = 350;
    }
  }

  void player() 
  {
    if (facingRight == 1)
    {
      fill(0);

      noStroke();
      //head
      rect(location.x - 5 * lookingRight, location.y - 125, location.x + 15 * lookingRight, location.y - 120);
      rect(location.x - 10 * lookingRight, location.y - 120, location.x + 15 * lookingRight, location.y - 115);
      rect(location.x - 15 * lookingRight, location.y - 115, location.x + 25 * lookingRight, location.y - 110);  
      rect(location.x - 20 * lookingRight, location.y - 110, location.x + 25 * lookingRight, location.y - 90);
      rect(location.x - 20 * lookingRight, location.y - 100, location.x + 25 * lookingRight, location.y - 75);
      rect(location.x - 20 * lookingRight, location.y - 90, location.x + 20 * lookingRight, location.y - 70);

      if (Alive)
      {
        fill(#ffffff);
        rect(location.x - 5 * lookingRight, location.y - 120, location.x + 10 * lookingRight, location.y - 115);
        fill(#c9c9c9);
        rect(location.x + 5 * lookingRight, location.y - 120, location.x + 10 * lookingRight, location.y - 115);
        rect(location.x - 10 * lookingRight, location.y - 115, location.x, location.y - 110);
        rect(location.x - 15 * lookingRight, location.y - 110, location.x- 5 * lookingRight, location.y - 100);
        rect(location.x - 15 * lookingRight, location.y - 100, location.x- 10 * lookingRight, location.y - 95);
        rect(location.x, location.y - 110, location.x + 5 * lookingRight, location.y - 100);
        rect(location.x + 5 * lookingRight, location.y - 110, location.x + 15 * lookingRight, location.y - 105);
        rect(location.x + 10 * lookingRight, location.y - 115, location.x + 15 * lookingRight, location.y - 105);
        rect(location.x + 20 * lookingRight, location.y - 105, location.x + 25 * lookingRight, location.y - 110);

        fill(#8e8e8e);
        rect(location.x - 15 * lookingRight, location.y - 95, location.x - 10 * lookingRight, location.y - 75);
        rect(location.x - 10 * lookingRight, location.y - 100, location.x - 5 * lookingRight, location.y - 95);
        rect(location.x - 5 * lookingRight, location.y - 95, location.x + 25 * lookingRight, location.y - 90);
        rect(location.x, location.y - 100, location.x + 5 * lookingRight, location.y - 95);
        rect(location.x + 10 * lookingRight, location.y - 105, location.x + 15 * lookingRight, location.y - 95);
        rect(location.x + 20 * lookingRight, location.y - 105, location.x + 25 * lookingRight, location.y - 95);
        fill(#ff9e9e);
        rect(location.x - 5 * lookingRight, location.y - 85, location.x + 20 * lookingRight, location.y - 80);
        rect(location.x, location.y - 80, location.x + 20 * lookingRight, location.y - 75);
      }

      //body
      fill(0);
      rect(location.x - 15 * lookingRight, location.y - 70, location.x + 25 * lookingRight, location.y - 25);
      rect(location.x - 10 * lookingRight, location.y - 25, location.x + 20 * lookingRight, location.y - 20);

      if (Alive)
      {
        fill(#c9c9c9);
        rect(location.x - 10 * lookingRight, location.y - 70, location.x + 20 * lookingRight, location.y - 25);
        fill(#8e8e8e);
        rect(location.x - 10 * lookingRight, location.y - 65, location.x + 10 * lookingRight, location.y - 25);
        rect(location.x - 10 * lookingRight, location.y - 60, location.x + 20 * lookingRight, location.y - 25);
      }

      //legs

      fill(0);
      rect(location.x - 10 * lookingRight, location.y - 20, location.x - 5 * lookingRight, location.y - 5);
      rect(location.x - 15 * lookingRight, location.y - 10, location.x - 5 * lookingRight, location.y - 5);
      rect(location.x - 15 * lookingRight, location.y - 10, location.x - 10 * lookingRight, location.y - 0);
      rect(location.x + 20 * lookingRight, location.y - 25, location.x + 25 * lookingRight, location.y - 0);

      //right arm
      fill(0);
      rect(location.x - 25 * lookingRight, location.y - 70, location.x, location.y - 55);
      rect(location.x - 30 * lookingRight, location.y - 65, location.x - 5 * lookingRight, location.y - 50);
      rect(location.x - 35 * lookingRight, location.y - 50, location.x - 15 * lookingRight, location.y - 40);
      rect(location.x - 40 * lookingRight, location.y - 40, location.x - 20 * lookingRight, location.y - 25);

      if (Alive)
      {
        fill(#8e8e8e);
        rect(location.x - 15 * lookingRight, location.y - 70, location.x - 5 * lookingRight, location.y - 60);
        rect(location.x - 25 * lookingRight, location.y - 65, location.x - 10 * lookingRight, location.y - 55);  
        rect(location.x - 30 * lookingRight, location.y - 50, location.x - 15 * lookingRight, location.y - 45);
        rect(location.x - 30 * lookingRight, location.y - 45, location.x - 20 * lookingRight, location.y - 40);

        fill(#c9c9c9);
        rect(location.x - 15 * lookingRight, location.y - 70, location.x - 5 * lookingRight, location.y - 65);
        rect(location.x - 25 * lookingRight, location.y - 65, location.x - 15 * lookingRight, location.y - 60);
        rect(location.x - 35 * lookingRight, location.y - 40, location.x - 25 * lookingRight, location.y - 30);

        fill(#ffffff);    
        rect(location.x - 15 * lookingRight, location.y - 70, location.x - 10 * lookingRight, location.y - 65);
        rect(location.x - 25 * lookingRight, location.y - 65, location.x - 20 * lookingRight, location.y - 60);

        rect(location.x - 35 * lookingRight, location.y - 40, location.x - 30 * lookingRight, location.y - 35);
      }

      //left arm
      fill(0);
      rect(location.x + 25 * lookingRight, location.y - 75, location.x + 35 * lookingRight, location.y - 50);
      rect(location.x + 35 * lookingRight, location.y - 70, location.x + 40 * lookingRight, location.y - 55);

      if (Alive)
      {
        fill(#8e8e8e);
        rect(location.x + 30 * lookingRight, location.y - 70, location.x + 35 * lookingRight, location.y - 55);

        fill(#c9c9c9);
        rect(location.x + 30 * lookingRight, location.y - 70, location.x + 35 * lookingRight, location.y - 65);
      }

      //sword
      fill(0);
      rect(location.x - 30 * lookingRight, location.y - 40, location.x - 20 * lookingRight, location.y - 20);
      rect(location.x - 20 * lookingRight, location.y - 40, location.x - 10 * lookingRight, location.y - 25);
      rect(location.x - 10 * lookingRight, location.y - 45, location.x, location.y - 30);
      rect(location.x, location.y - 50, location.x + 15 * lookingRight, location.y - 35);
      rect(location.x + 15, location.y - 55, location.x + 30, location.y - 40);

      if (Alive)
      {
        fill(#ffffff);
        rect(location.x - 25 * lookingRight, location.y - 35, location.x - 20 * lookingRight, location.y - 25);
        rect(location.x - 20 * lookingRight, location.y - 35, location.x - 10 * lookingRight, location.y - 30);   
        rect(location.x - 10 * lookingRight, location.y - 40, location.x, location.y - 35);
        rect(location.x, location.y - 45, location.x + 15, location.y - 40);
        rect(location.x + 15, location.y - 50, location.x + 30, location.y - 45);
      }

      //shield
      if (keyPressed)
      {
        if (key == 'j')
        {
          fill(0);
          rect(location.x + 40, location.y - 95, location.x + 65, location.y - 90);
          rect(location.x + 35, location.y - 90, location.x + 65, location.y - 85);
          rect(location.x + 35, location.y - 85, location.x + 65, location.y - 45);
          rect(location.x + 35, location.y - 45, location.x + 65, location.y - 35);
          rect(location.x + 40, location.y - 35, location.x + 65, location.y - 25);
          rect(location.x + 45, location.y - 25, location.x + 65, location.y - 20);
          rect(location.x + 50, location.y - 20, location.x + 60, location.y - 15);
          if (Alive)
          {
            fill(#c9c9c9);
            rect(location.x + 35, location.y - 85, location.x + 40, location.y - 45);
            rect(location.x + 40, location.y - 70, location.x + 45, location.y - 35);
            rect(location.x + 45, location.y - 35, location.x + 50, location.y - 25);
            rect(location.x + 50, location.y - 25, location.x + 60, location.y - 20);
            rect(location.x + 45, location.y - 85, location.x + 60, location.y - 80);

            fill(#ffffff);
            rect(location.x + 40, location.y - 90, location.x + 60, location.y - 85);
            rect(location.x + 35, location.y - 85, location.x + 45, location.y - 80);

            fill(#0300bb);
            rect(location.x + 50, location.y - 65, location.x + 60, location.y - 25);
            rect(location.x + 45, location.y - 65, location.x + 60, location.y - 35);
            rect(location.x + 40, location.y - 60, location.x + 60, location.y - 50);

            fill(#0f36ff);
            rect(location.x + 50, location.y - 65, location.x + 60, location.y - 45);
            rect(location.x + 55, location.y - 65, location.x + 60, location.y - 35);

            fill(#1333d9);
            rect(location.x + 50, location.y - 85, location.x + 60, location.y - 65);
            rect(location.x + 40, location.y - 80, location.x + 60, location.y - 70);
            rect(location.x + 45, location.y - 70, location.x + 60, location.y - 65);

            fill(#f0ff00);
            rect(location.x + 50, location.y - 70, location.x + 60, location.y - 65);
            rect(location.x + 55, location.y - 65, location.x + 60, location.y - 60);
            rect(location.x + 55, location.y - 55, location.x + 60, location.y - 50);
          }
        }
      }
    } else
    {
      fill(0);
      noStroke();
      //head
      rect(location.x - 5 * -1, location.y - 125, location.x + 15 * -1, location.y - 120);
      rect(location.x - 10 * -1, location.y - 120, location.x + 15 * -1, location.y - 115);
      rect(location.x - 15 * -1, location.y - 115, location.x + 25 * -1, location.y - 110);  
      rect(location.x - 20 * -1, location.y - 110, location.x + 25 * -1, location.y - 90);
      rect(location.x - 20 * -1, location.y - 100, location.x + 25 * -1, location.y - 75);
      rect(location.x - 20 * -1, location.y - 90, location.x + 20 * -1, location.y - 70);

      if (Alive)
      {
        fill(#ffffff);
        rect(location.x - 5 * -1, location.y - 120, location.x + 10 * -1, location.y - 115);
        fill(#c9c9c9);
        rect(location.x + 5 * -1, location.y - 120, location.x + 10 * -1, location.y - 115);
        rect(location.x - 10 * -1, location.y - 115, location.x, location.y - 110);
        rect(location.x - 15 * -1, location.y - 110, location.x- 5 * -1, location.y - 100);
        rect(location.x - 15 * -1, location.y - 100, location.x- 10 * -1, location.y - 95);
        rect(location.x, location.y - 110, location.x + 5 * -1, location.y - 100);
        rect(location.x + 5 * -1, location.y - 110, location.x + 15 * -1, location.y - 105);
        rect(location.x + 10 * -1, location.y - 115, location.x + 15 * -1, location.y - 105);
        rect(location.x + 20 * -1, location.y - 105, location.x + 25 * -1, location.y - 110);

        fill(#8e8e8e);
        rect(location.x - 15 * -1, location.y - 95, location.x - 10 * -1, location.y - 75);
        rect(location.x - 10 * -1, location.y - 100, location.x - 5 * -1, location.y - 95);
        rect(location.x - 5 * -1, location.y - 95, location.x + 25 * -1, location.y - 90);
        rect(location.x, location.y - 100, location.x + 5 * -1, location.y - 95);
        rect(location.x + 10 * -1, location.y - 105, location.x + 15 * -1, location.y - 95);
        rect(location.x + 20 * -1, location.y - 105, location.x + 25 * -1, location.y - 95);
        fill(#ff9e9e);
        rect(location.x - 5 * -1, location.y - 85, location.x + 20 * -1, location.y - 80);
        rect(location.x, location.y - 80, location.x + 20 * -1, location.y - 75);
      }

      //body
      fill(0);
      rect(location.x - 15* -1, location.y - 70, location.x + 25* -1, location.y - 25);
      rect(location.x - 10* -1, location.y - 25, location.x + 20* -1, location.y - 20);
      if (Alive)
      {      
        fill(#c9c9c9);
        rect(location.x - 10* -1, location.y - 70, location.x + 20* -1, location.y - 25);
        fill(#8e8e8e);
        rect(location.x - 10* -1, location.y - 65, location.x + 10* -1, location.y - 25);
        rect(location.x - 10* -1, location.y - 60, location.x + 20* -1, location.y - 25);
      }

      //legs
      fill(0);
      rect(location.x - 10* -1, location.y - 20, location.x - 5* -1, location.y - 5);
      rect(location.x - 15* -1, location.y - 10, location.x - 5* -1, location.y - 5);
      rect(location.x - 15* -1, location.y - 10, location.x - 10* -1, location.y - 0);
      rect(location.x + 20* -1, location.y - 25, location.x + 25* -1, location.y - 0);

      //right arm
      fill(0);
      rect(location.x - 25* -1, location.y - 70, location.x, location.y - 55);
      rect(location.x - 30* -1, location.y - 65, location.x - 5* -1, location.y - 50);
      rect(location.x - 35* -1, location.y - 50, location.x - 15* -1, location.y - 40);
      rect(location.x - 40* -1, location.y - 40, location.x - 20* -1, location.y - 25);

      if (Alive)
      {
        fill(#8e8e8e);
        rect(location.x - 15* -1, location.y - 70, location.x - 5* -1, location.y - 60);
        rect(location.x - 25* -1, location.y - 65, location.x - 10* -1, location.y - 55);  
        rect(location.x - 30* -1, location.y - 50, location.x - 15* -1, location.y - 45);
        rect(location.x - 30* -1, location.y - 45, location.x - 20* -1, location.y - 40);

        fill(#c9c9c9);
        rect(location.x - 15* -1, location.y - 70, location.x - 5* -1, location.y - 65);
        rect(location.x - 25* -1, location.y - 65, location.x - 15* -1, location.y - 60);
        rect(location.x - 35* -1, location.y - 40, location.x - 25* -1, location.y - 30);

        fill(#ffffff);    
        rect(location.x - 15* -1, location.y - 70, location.x - 10* -1, location.y - 65);
        rect(location.x - 25* -1, location.y - 65, location.x - 20* -1, location.y - 60);

        rect(location.x - 35* -1, location.y - 40, location.x - 30* -1, location.y - 35);
      }

      //left arm
      fill(0);
      rect(location.x + 25* -1, location.y - 75, location.x + 35* -1, location.y - 50);
      rect(location.x + 35* -1, location.y - 70, location.x + 40* -1, location.y - 55);

      if (Alive)
      {
        fill(#8e8e8e);
        rect(location.x + 30* -1, location.y - 70, location.x + 35* -1, location.y - 55);

        fill(#c9c9c9);
        rect(location.x + 30* -1, location.y - 70, location.x + 35* -1, location.y - 65);
      }

      //sword
      fill(0);
      rect(location.x - 30* -1, location.y - 40, location.x - 20* -1, location.y - 20);
      rect(location.x - 20* -1, location.y - 40, location.x - 10* -1, location.y - 25);
      rect(location.x - 10* -1, location.y - 45, location.x, location.y - 30);
      rect(location.x, location.y - 50, location.x + 15* -1, location.y - 35);
      rect(location.x + 15* -1, location.y - 55, location.x + 30* -1, location.y - 40);
      if (Alive)
      {
        fill(#ffffff);
        rect(location.x - 25* -1, location.y - 35, location.x - 20* -1, location.y - 25);
        rect(location.x - 20* -1, location.y - 35, location.x - 10* -1, location.y - 30);   
        rect(location.x - 10* -1, location.y - 40, location.x, location.y - 35);
        rect(location.x, location.y - 45, location.x + 15* -1, location.y - 40);
        rect(location.x + 15* -1, location.y - 50, location.x + 30* -1, location.y - 45);
      }

      //shield
      if (keyPressed)
      {
        if (key == 'j')
        {
          fill(0);
          rect(location.x + 40* -1, location.y - 95, location.x + 65* -1, location.y - 90);
          rect(location.x + 35* -1, location.y - 90, location.x + 65* -1, location.y - 85);
          rect(location.x + 35* -1, location.y - 85, location.x + 65* -1, location.y - 45);
          rect(location.x + 35* -1, location.y - 45, location.x + 65* -1, location.y - 35);
          rect(location.x + 40* -1, location.y - 35, location.x + 65* -1, location.y - 25);
          rect(location.x + 45* -1, location.y - 25, location.x + 65* -1, location.y - 20);
          rect(location.x + 50* -1, location.y - 20, location.x + 60* -1, location.y - 15);

          if (Alive)
          {
            fill(#c9c9c9);
            rect(location.x + 35* -1, location.y - 85, location.x + 40* -1, location.y - 45);
            rect(location.x + 40* -1, location.y - 70, location.x + 45* -1, location.y - 35);
            rect(location.x + 45* -1, location.y - 35, location.x + 50* -1, location.y - 25);
            rect(location.x + 50* -1, location.y - 25, location.x + 60* -1, location.y - 20);
            rect(location.x + 45* -1, location.y - 85, location.x + 60* -1, location.y - 80);

            fill(#ffffff);
            rect(location.x + 40* -1, location.y - 90, location.x + 60* -1, location.y - 85);
            rect(location.x + 35* -1, location.y - 85, location.x + 45* -1, location.y - 80);

            fill(#0300bb);
            rect(location.x + 50* -1, location.y - 65, location.x + 60* -1, location.y - 25);
            rect(location.x + 45* -1, location.y - 65, location.x + 60* -1, location.y - 35);
            rect(location.x + 40* -1, location.y - 60, location.x + 60* -1, location.y - 50);

            fill(#0f36ff);
            rect(location.x + 50* -1, location.y - 65, location.x + 60* -1, location.y - 45);
            rect(location.x + 55* -1, location.y - 65, location.x + 60* -1, location.y - 35);

            fill(#1333d9);
            rect(location.x + 50* -1, location.y - 85, location.x + 60* -1, location.y - 65);
            rect(location.x + 40* -1, location.y - 80, location.x + 60* -1, location.y - 70);
            rect(location.x + 45* -1, location.y - 70, location.x + 60* -1, location.y - 65);

            fill(#f0ff00);
            rect(location.x + 50* -1, location.y - 70, location.x + 60* -1, location.y - 65);
            rect(location.x + 55* -1, location.y - 65, location.x + 60* -1, location.y - 60);
            rect(location.x + 55* -1, location.y - 55, location.x + 60* -1, location.y - 50);
          }
        }
      }
    }
  }
}