/*
  KXI core functions V1 - FOR PUBLIC
 by: Khan-ali Ibrahim
 
 Functions for common use tasks, work smart not hard people.
 Mainly to handle mouse events but I stuff other stuff I need in there.
 
 This is a class I pass around, you are free to use as long as you credit me.
 
 Don't instantiate/call the function in SETUP, do it in DRAW or else the mouse events won't work
 repeat do (name of object) = new KXIcore(mouseX, mouseY, mousePressed); IN DRAW
 */

class KXIcore {
  //varibles
  float mX, //mouseX
    mY; //mouseY
  boolean mP; //mousePressed

  //Constructor to pass the mouse inputs along
  KXIcore(int x, int y, boolean p) {
    mX = x;
    mY = y;
    mP = p;
  }

  //function that draws an invisible rectangle in CORNERS mode
  //if the mouse is over the invisble box it returns true
  boolean mouseOverCorner(float leftX, float leftY, float rightX, float rightY) {
    if (mX > leftX && mX < rightX && mY > leftY && mY < rightY) {
      return true;
    } else {
      return false;
    }
  }

  //function that draws an invisible rectangle in CORNERS mode
  //if the mouse is over and pressed in the invisble box it returns true
  boolean mouseClickCorner(float leftX, float leftY, float rightX, float rightY) {
    if (mouseOverCorner(leftX, leftY, rightX, rightY) && mP) {
      return true;
    } else {
      return false;
    }
  }

  //function that draws an invisible rectangle in CENTER mode
  //if the mouse is over the invisble box it returns true
  boolean mouseOverCenter(float centerX, float centerY, float sizeX, float sizeY) {
    //finds the sides of the rectangle
    float leftSide = centerX - (sizeX/2), 
      rightSide = centerX + (sizeX/2), 
      topSide = centerY - (sizeY/2), 
      bottomSide = centerY + (sizeY/2);

    if (mX > leftSide && mX < rightSide && mY > topSide && mY < bottomSide) {
      return true;
    } else {
      return false;
    }
  }

  //function that draws an invisible rectangle in CENTER mode
  //if the mouse is over and pressed in the invisble box it returns true
  boolean mouseClickCenter(float centerX, float centerY, float sizeX, float sizeY) {
    if (mouseOverCenter(centerX, centerY, sizeX, sizeY) && mP) {
      return true;
    } else {
      return false;
    }
  }

  //function that when given a two points and one point inbetween them will calculate the percentage
  //between the two points // I used this for my sliders
  float findPercent(int min, int max, int value) {
    //I don't remember the math since I wrote this when I was at night and tired, but it works
    float rangeDistance = max - min;
    float valueDistance = value - min;

    //returns percentage
    return (valueDistance / rangeDistance) * 1;
  }
  
  
  //finds the centerpoint between two points
  float findMidpoint (float pointA, float pointB) {
    //middle school math people, middle school math
    return (pointA + pointB) / 2;
  }
}