class Bubbles {
  PVector location;
  PVector velocity;
  PVector acceleration;
  PVector mouse;
  PVector dir;
  float topspeed;
  //Boolean to check if mouse is clicked on hair in Bubble and Shower mode
  Boolean hairClickBubble = false;
  Boolean hairClickShower = false;
  //Boolean to check if bubble is released yet
  Boolean releaseCheck = false;

  Bubbles () {
    velocity = new PVector(random(-0.5, 0.5), random(-0.5, 0.5));
    acceleration = new PVector(0, 0);
    topspeed = 0.2;
  }

  void update() {
    // make bubbles slowly follow the mouse
    PVector mouse = new PVector(mouseX, mouseY);
    PVector dir = PVector.sub(mouse, location);
    dir.normalize();
    dir.mult(0.02);
    acceleration = dir;
    velocity.add(acceleration);
    velocity.limit(topspeed);
    location.add(velocity);
  }

  void edgeLimit() {
    // constrain bubbles to stay inside hair area
    if (location.x > 270 || location.x < 130 || ((location.x >160) && (location.x<240) && (location.y>200))) {
      velocity.x = velocity.x * -1;
    }
    if (location.y > 290 || location.y < 150 || ((location.x > 160) && (location.x < 240) && (location.y>200))) {
      velocity.y = velocity.y * -1;
    }
  }

  void display() {
    stroke(255);
    fill(255, 255, 255, 100);
    ellipse(location.x, location.y, 25, 25);
  }

  void reset() {
    // reset bubble location ouside of screen to seem like they disappear
    location= new PVector(500, 500);
    hairClickBubble= false;
    // when bubble disappear reset their release status to false
    releaseCheck = false;
  }

  // Check if mouse clicked on hair when bubble mode is on
  void hairBubbleCheck() {
    if ((mousePressed==true) && (bubbleMode==true) && (((mouseX>130) && (mouseX<160))  || ((mouseX>240) && (mouseX<270)) || ((mouseX>130) && (mouseX<270) && (mouseY>150) && (mouseY<200))) && (mouseY>150) && (mouseY<290)) {
      if (hairClickBubble == false)
      {
        hairClickShower=false;
      }
      hairClickBubble = true;
    } else
    {
      hairClickBubble = false;
    }
  }

  //Check if mouse clicked on hair when shower mode is on
  void hairShowerCheck() {
    // bubbles have no location before released so this function will crash, add if statement to make sure location is not null
    if (location != null)
    {
      if ((mousePressed==true) && (showerMode==true) && (dist(mouseX, mouseY, location.x, location.y))<30) {
        hairClickShower = true;
      }
    }
  }
}