/***************************************************
 *File Name: Hair_Wash
 *Author: Sin I Lei
 *Date: Oct 15, 2016
 *Descrpition: An interactive toy featuring
 *a girl at a hair salon
 *Click on the bubble icon then her hair to apply shampoo
 *Click on the shower icon then her hair to rinse the bubbles
 **************************************************/

// Declare variables
Girl girl1;
IconBubble iconBubbleButton;
IconShower iconShowerButton;
IconBubble iconBubbleMouse;
IconShower iconShowerMouse;

// Declare array of bubbles
Bubbles[] bubbles = new Bubbles [60];

//Boolean to check which mode is on
Boolean bubbleMode = false;
Boolean showerMode = false;

//Timer variable to count the number of frames
int timer =0;




void setup () {
  size(400, 400);
  println("Click on the bubble icon then her hair to apply shampoo");
  println("Click on the shower icon then her hair to rinse the bubbles");

  // Initialize girl object
  girl1 = new Girl();

  // Initialize Bubble button at top
  iconBubbleButton = new IconBubble(240, 40);

  // Initialize Shower button at top
  iconShowerButton = new IconShower(150, 40);

  // Inialize bubbles array
  for (int i=0; i<bubbles.length; i++) {
    bubbles[i]=new Bubbles();
  }
}



void draw() {

  //background settings
  background(178, 235, 230);
  girl1.display();
  iconBubbleButton.display();
  iconShowerButton.display();

  //mode check
  bubbleCheck ();
  showerCheck ();
  bubbleMouse ();
  showerMouse ();


  //check if mouse is clicked on the hair when bubble mode is on
  for (int i=0; i<bubbles.length; i++) {
    bubbles[i].hairBubbleCheck();
  }

  //when mouse is pressed the timer starts counting
  timeCount();
  //update bubbles location every 10 frames if mouse clicks on hair while in bubble mode
  updateBubbles();
  //display bubbles
  displayBubbles();

  //check if mouse is clicked on the bubbles when shower mode is on
  for (int i=0; i<bubbles.length; i++) {
    bubbles[i].hairShowerCheck();
  }
  //make bubbles disappear if click on bubbles in shower mode
  rinseBubbles();
}



//////////////////////BUBBLE OR SHOWER MODE FUNCTIONS/////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

// Turn on bubble mode if mouse pressed on bubble button
void bubbleCheck () {
  if ((mousePressed==true) && (mouseX>230) && (mouseX<260) && (mouseY>30) && (mouseY<60)) {
    bubbleMode= true;
    showerMode= false;
  }
}

// Turn on shower mode if mouse pressed on shower button
void showerCheck () {
  if ((mousePressed==true) && (mouseX>130) && (mouseX<180) && (mouseY>30) && (mouseY<60)) {
    showerMode= true;
    bubbleMode= false;
  }
}

// Draw bubble as mouse cursor if bubble mode is on
void bubbleMouse () {
  if (bubbleMode==true) {
    iconBubbleMouse = new IconBubble(mouseX, mouseY);
    iconBubbleMouse.display();
  }
}

// Draw shower as mouse cursor if shower mode is on
void showerMouse () {
  if (showerMode==true) {
    iconShowerMouse = new IconShower(mouseX, mouseY);
    iconShowerMouse.display();
  }
}

///////////////////////CREATE BUBBLES AND RINSE BUBBLES FUNCTIONS////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////


// Make bubbles disappear if mouse clicks on hair when shower mode is on
void rinseBubbles () {

  for (int i=0; i<bubbles.length; i++) {
    if (bubbles[i].hairClickShower==true) {
      bubbles[i].reset();
    }
  }
}

// Add time whenever mouse is clicked
void timeCount() {
  if (mousePressed==true) {
    timer++;
  }
}

// Update bubble when clicked on hair in bubble mode each time 10 frames has passed
void updateBubbles() {
  for (int i=0; i<bubbles.length; i++) {
    if (timer>=10 && bubbles[i].hairClickBubble==true && bubbles[i].releaseCheck==false) {
      bubbles[i].location= new PVector(mouseX, mouseY);
      //only release bubble that has not been released yet
      bubbles[i].releaseCheck=true;
      timer=0;
    }
  }
}

// Display bubbles that has been updated
void displayBubbles() {
  for (int i=0; i<bubbles.length; i++) {
    if (bubbles[i].releaseCheck==true ) {
      bubbles[i].update();
      bubbles[i].edgeLimit();
      bubbles[i].display();
    }
  }
}