/*
Freespace Live Map
By: Khan-ali Ibrahim for IMC @ Sheridan College
October 2016 - Still

Explore a randomly generated map that is alive and busy! Trade between space stations to affect their 
growth yourself. The space stations grow and level up themselves, and get more resources.

The goal was to make something that will be active and change on its own, I've been surprised when I leave
the program running and come back to it being completly changed.

- move towards the edge of the map to scroll around
- click on a space station to select it
- use the menu on the side to give and take resources from the selected station
 */

//Varibles
int numOfStations = 85;
//Focus for UI
int UItargetFocus = 0;
float mapSize = 0.5, 
  mapScrollSpeed = 3;
//world center for the map scrolling
PVector worldCenter;

KXIcore core;
spaceStation[] stations = new spaceStation[numOfStations];
tradeUI ui = new tradeUI(new PVector(700, 300));


void setup() {
  size(800, 600);
  //frame rate for counting logic
  frameRate(60);
  
  //send out instructions
  println("Welcome to Freespace! move towards the edge of the map to scroll around, click on a space station to select it, use the menu on the side to give and take resources from the selected station");

  //world center to center of frame
  worldCenter = new PVector(width/2, height/2);

  for (int i = 0; i < numOfStations; i++) {
    //gaussian  is much prettier than plain random
    stations[i] = new spaceStation(
      (randomGaussian() * width * mapSize), 
      (randomGaussian() * height * mapSize), i);
  }
}

void draw() {
  //initilize core
  core = new KXIcore(mouseX, mouseY, mousePressed);

  background(#263238);
  
  //handle map movement
  handleMapMove(50);

  //draw the trade lines, under the stations
  for (int i = 0; i < stations.length; i++) {
    stations[i].drawTradeLine(worldCenter);

    //if the station is clicked, put this here to handle logic before drawing
    if (core.mouseClickCenter(stations[i].position.x + worldCenter.x, stations[i].position.y  + worldCenter.y, stations[i].size.x, stations[i].size.y)) {
      UItargetFocus = i;
      //println("Hello from " + stations[i].id);
    }
  }

  //draw stations and activate the station trading logic
  for (int i = 0; i < stations.length; i++) {
    stations[i].findTradePartner(stations);
    stations[i].display(worldCenter);
  }

  //tell the trade handling what to focus on
  ui.updateTarget(UItargetFocus, stations);
  ui.display();
}

//handles the movement around the map
//everything is drawn relitive to the world center, if it moves EVERYTHING moves
void handleMapMove (int area) {
  //if on edge of screen and not to the limits, move the world center
  if (mouseX < area && worldCenter.x < 900) {
    worldCenter.x += mapScrollSpeed;
  } else if (mouseX > (width - 250) && mouseX < (width - 200) && worldCenter.x > -200) {
    worldCenter.x -= mapScrollSpeed;
  }

  if (mouseY < area && worldCenter.y < 700) {
    worldCenter.y += mapScrollSpeed;
  } else if (mouseY > (height - 50) && worldCenter.y > -200) {
    worldCenter.y -= mapScrollSpeed;
  }
}