/*
  This can bully space stations FYI
*/

class tradeUI {
  PVector position;
  PVector targetPosition;
  int targetID = -1, 
    targetLvl, 
    resourceMax;
  int[] resource = new int[4];

  boolean[] hasResource = {false, false, false, false};

  int barLength = 41, 
    barHeight = 250, 
    barPadding = 7;

  //cooldown to prevent spamming
  float tradeCd = 30;
  
  color[] resourceCol = new color[] {#FF5722, #8BC34A, #00BCD4, #673AB7};

  tradeUI (PVector pos) {
    position = pos;
  }

  //updates information that the UI knows
  void updateTarget(int id, spaceStation[] tar) {
    targetID = id;
    targetLvl = tar[id].lvl;
    targetPosition = tar[id].position;

    for (int i = 0; i < resource.length; i++) {
      resource[i] = tar[id].resources[i];
    }

    resourceMax = tar[id].resourcesMax;
  }

  void display() {
    //setup
    rectMode(CENTER);
    barHeight = int(250 * (float(resourceMax) / 3000));

    //indicator
    noFill();
    stroke(255);
    strokeWeight(2);
    ellipseMode(CENTER);
    ellipse(targetPosition.x + worldCenter.x, targetPosition.y + worldCenter.y, 25, 25);

    //background
    fill(#90A4AE);
    noStroke();
    rect(position.x, position.y, 200, height);

    //station name
    fill(0);
    textSize(12);
    text("lvl: " + targetLvl + " | Station Number # " + targetID, position.x - 90, 30);

    //bars and stuff
    for (int i = 0; i < resource.length; i++) {
      noStroke();
      rectMode(CORNERS);

      //bar fill
      fill(resourceCol[i]);
      rect(position.x - 100 + (barLength * i) + (barPadding * (i + 1)), position.y - 190, 
        position.x - 100 + (barLength * (i + 1)) + (barPadding * (i + 1)), barHeight + position.y - 190);

      //bar background
      fill(#607D8B);
      rect(position.x - 100 + (barLength * i) + (barPadding * (i + 1)), position.y - 190, 
        position.x - 100 + (barLength * (i + 1)) + (barPadding * (i + 1)), 
        int(-(core.findPercent(0, resourceMax, resource[i]) - 1) * barHeight) + position.y - 190);

      //button
      rectMode(CENTER);
      fill(#37474F);
      rect(position.x - 79 + (barLength * i) + (barPadding * (i + 1)), position.y - 210, barLength, barLength * 0.6);

      //button arrow
      drawArrow(int(position.x - 79 + (barLength * i) + (barPadding * (i + 1))), int(position.y - 210), hasResource[i]);

      //button logic
      if (core.mouseClickCenter(position.x - 79 + (barLength * i) + (barPadding * (i + 1)), position.y - 210, barLength, barLength * 0.6)
        && tradeCd < 0) {
        handleTrade(i);
        tradeCd = 30;
      }

      //invintory
      noStroke();
      fill(hasResource[i] ? resourceCol[i] : #607D8B);
      rect(position.x - 79 + (barLength * i) + (barPadding * (i + 1)), position.y - 240, barLength, barLength * 0.6);

      //fill(0); //debug
      //text("Resource " + (i + 1) + ": " + resource[i] + " / " +  resourceMax, position.x - 80, (100 + (i * 30)));
    }

    //handleCooldown
    tradeCd -= 1;
  }

  //UI trading
  void handleTrade(int num) {
    if (hasResource[num]) {
      stations[targetID].resources[num] += 200;
      hasResource[num] = false;
    } else {
      stations[targetID].resources[num] -= 200;
      hasResource[num] = true;
    }
  }

  //flips it up and down
  void drawArrow(int x, int y, boolean up) {
    stroke(255);
    strokeWeight(3);
    //messed up with where it was, too lazy to move around the code
    if (!up) {
      line(x, y - 5, x - 15, y + 5);
      line(x, y - 5, x + 15, y + 5);
    } else {
      line(x, y + 5, x - 15, y - 5);
      line(x, y + 5, x + 15, y - 5);
    }
  }
}