//Bunny character class
class Bunny {

  //Declare bunny variables 
  float orientation;
  float moveSpeed;
  float verticalSpeed;
  float jumpPower;
  float gravity;
  float floor;
  PVector bunnyPosition;
  PVector bunnyMain;

  //Bunny constructor - declare variable values  
  Bunny(float x, float y) {
    bunnyPosition = new PVector(x, y);
    moveSpeed = 10;
    jumpPower = -20;
    gravity = 1;
    orientation = 1;
    floor = 500;
  }

  //Draw bunny's body, and set functions for bunny's movements, speed, gravity and jump  
  void display() {
    updateHeight();
    fill(255);
    noStroke();

    //Draw Bunny    
    //Body
    setbunnyMain(0, 0);
    ellipse(bunnyMain.x, bunnyMain.y, 40, 35);

    //Head
    setbunnyMain(20, -10);
    ellipse(bunnyMain.x, bunnyMain.y, 28, 28);


    //left Ear
    setbunnyMain(14, -30);
    ellipse(bunnyMain.x, bunnyMain.y, 10, 20);

    //Right Ear
    setbunnyMain(26, -30);
    ellipse(bunnyMain.x, bunnyMain.y, 10, 20);

    // Tail
    setbunnyMain(-20, -5);
    ellipse(bunnyMain.x, bunnyMain.y, 10, 10);

    //Leg
    stroke(255);
    strokeWeight(10);
    setbunnyMain(-8, 16);
    line(bunnyMain.x, bunnyMain.y, bunnyMain.x + 7 * orientation, bunnyMain.y);

    //Arm
    setbunnyMain(10, 10);
    line(bunnyMain.x, bunnyMain.y, bunnyMain.x + 2  * orientation, bunnyMain.y + 6);

    //Left Eye
    noStroke();
    fill(180, 210, 250);
    setbunnyMain(14, -12);
    ellipse(bunnyMain.x, bunnyMain.y, 7, 7);

    //Right Eye
    setbunnyMain(26, -12);
    ellipse(bunnyMain.x, bunnyMain.y, 7, 7);

    //Nose
    fill(180, 130, 145);
    setbunnyMain(20, -7);
    triangle(bunnyMain.x - 2.5 * orientation, bunnyMain.y, bunnyMain.x + 2.5 * orientation, bunnyMain.y, bunnyMain.x, bunnyMain.y + 2);
  }

  //Bunny follow MouseY's position
  void moveTowards(float x) {
    if (x == bunnyPosition.x) {
      return;
    }

    // Bunny cannot go faster than speed    
    float distance = abs(x - bunnyPosition.x);
    if (distance > moveSpeed) {
      distance = moveSpeed;
    }

    //Bunny going right and left    
    if (bunnyPosition.x < x) {
      bunnyPosition.x += distance;
      orientation = 1;
    } else {
      bunnyPosition.x -= distance;
      orientation = -1;
    }
  }

  //Update vertical position of bunny
  void updateHeight() {
    verticalSpeed += gravity;
    bunnyPosition.y += verticalSpeed;

    //Constrain bunny to floor
    if (bunnyPosition.y >= floor) {
      bunnyPosition.y = floor;
      verticalSpeed = 0;
    }
  }

  //Bunny jumps and restricts it so that it cannot jump again in the air  
  void jump() {
    if (bunnyPosition.y < floor) {
      return;
    }
    verticalSpeed = jumpPower;
  }

  //Bunny will jump again in air after landing on a star  
  void airjump() {
    verticalSpeed = jumpPower;
  }

  //Settings to flip's bunny's position so it is facing the direction of the mouse 
  void setbunnyMain(float x, float y) {
    //bunnyMain = bunnyPosition.copy();
    bunnyMain = new PVector(bunnyPosition.x, bunnyPosition.y);
    bunnyMain.x += x * orientation;
    bunnyMain.y += y;
  }
}