//This class handles everything about the Easy Enemy class.
//Has a method to draw the enemy and update the position of the enemy. 

class EasyEnemy{
  float currentHealth;
  int easyEnemyType;
  int easyEnemyColour = 60;
  
  PVector centerPoint;
  float boundingDistance = 25/2;
  int movementSpeed = 1;
  PVector moveRightLeft= new PVector(movementSpeed,0);
  PVector moveUpDown= new PVector(0,movementSpeed);
  boolean movingRight=false;
  boolean movingLeft=false;
  boolean movingUp=false;
  boolean movingDown=false;
  
  EasyEnemy(int enemyType){
    centerPoint= new PVector(75,375);
    currentHealth = 10;
    easyEnemyType=enemyType;
  }
  
  void build(int enemyType){
    for(int lineNumber=1;lineNumber<=3;lineNumber++){
      noFill();
      strokeWeight((strkWght-2)-(2*(lineNumber-1)));
      stroke(easyEnemyColour,((30*lineNumber)-glowFrame),99,((30*lineNumber)-glowFrame));
      if (enemyType==0){
        if(movingRight){
          triangle(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x-boundingDistance,centerPoint.y+boundingDistance,centerPoint.x+boundingDistance,centerPoint.y);
        } else if (movingLeft){
          triangle(centerPoint.x-boundingDistance,centerPoint.y,centerPoint.x+boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance);
        } else if (movingUp){
          triangle(centerPoint.x-boundingDistance,centerPoint.y+boundingDistance,centerPoint.x,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance);
        } else if (movingDown){
          triangle(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x,centerPoint.y+boundingDistance,centerPoint.x+boundingDistance,centerPoint.y-boundingDistance);
        }
      } else if (enemyType==1){
        rect(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance);
      } else if (enemyType==2){
        rect(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance);
        line(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance);
        line(centerPoint.x-boundingDistance,centerPoint.y+boundingDistance,centerPoint.x+boundingDistance,centerPoint.y-boundingDistance);
      } else if (enemyType==3){
        if(movingRight || movingLeft){
          quad(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance,centerPoint.x-boundingDistance,centerPoint.y+boundingDistance,centerPoint.x+boundingDistance,centerPoint.y-boundingDistance);
        } else if (movingUp || movingDown){
          quad(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x-boundingDistance,centerPoint.y+boundingDistance,centerPoint.x+boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance);
        }
      } else if (enemyType==4){
        if (movingRight || movingLeft){
          quad(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x-boundingDistance,centerPoint.y+boundingDistance,centerPoint.x+boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance);
        } else if (movingUp || movingDown){
          quad(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance,centerPoint.x-boundingDistance,centerPoint.y+boundingDistance,centerPoint.x+boundingDistance,centerPoint.y-boundingDistance);
        }
      } else if (enemyType==5){
        line(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance);
        line(centerPoint.x-boundingDistance,centerPoint.y+boundingDistance,centerPoint.x+boundingDistance,centerPoint.y-boundingDistance);
      } else if (enemyType==6){
        ellipse(centerPoint.x-boundingDistance,centerPoint.y-boundingDistance,centerPoint.x+boundingDistance,centerPoint.y+boundingDistance);
      }
    }
  }
  
  void move(){
    if(centerPoint.x==75 && centerPoint.y==375){
      movingUp=false;
      movingDown=false;
      movingLeft=false;
      movingRight=true;
    }
    
    for(int pathwayCounter=0;pathwayCounter<pathwayCheckpointsX.length;pathwayCounter++){
      if (centerPoint.x==pathwayCheckpointsX[pathwayCounter] && centerPoint.y==pathwayCheckpointsY[pathwayCounter]){
        if (pathwayCounter==0 || pathwayCounter==2 || pathwayCounter==6 || pathwayCounter==8 || pathwayCounter==12){
          movingUp=true;
          movingDown=false;
          movingLeft=false;
          movingRight=false;
        } else if (pathwayCounter==4 || pathwayCounter==10){
          movingUp=false;
          movingDown=true;
          movingLeft=false;
          movingRight=false;
        } else if (pathwayCounter==1){
          movingUp=false;
          movingDown=false;
          movingLeft=true;
          movingRight=false;
        } else if (pathwayCounter==3 || pathwayCounter==5 || pathwayCounter==7 || pathwayCounter==9 || pathwayCounter==11){
          movingUp=false;
          movingDown=false;
          movingLeft=false;
          movingRight=true;
        } else if (pathwayCounter==13){
          movingUp=false;
          movingDown=false;
          movingLeft=false;
          movingRight=false;
        }
      }
    }
    
    if(movingRight){
      centerPoint.add(moveRightLeft);
    } else if (movingLeft){
      centerPoint.sub(moveRightLeft);
    } else if (movingUp){
      centerPoint.sub(moveUpDown);
    } else if (movingDown){
      centerPoint.add(moveUpDown);
    }
  }
}