//This class handles everything to do with the Light Tower's class.
//Has a method to construct the tower, draw the tower, draw the tower's button and shoot from the tower.

class LightTower{
  int xPoint1, yPoint1;
  int xPoint2, yPoint2;
  int xPoint3, yPoint3;
  int xPoint4, yPoint4;
  int xPoint5, yPoint5;
  int xPoint6, yPoint6;
  int xBounding1, yBounding1;
  int xBounding2, yBounding2;
  float bulletDamage;
  int firingRadius;
  boolean enemyLockedOn;
  PVector bulletLocation;
  int lightTowerColour = 122;
  boolean isBoundToMouse=false;
  int lightTowerVersion;
  
  
  LightTower(int towerVersion, int referencePointX, int referencePointY){
    if (towerVersion==0){
      xPoint1 = referencePointX-25;
      yPoint1 = referencePointY-25;
      xPoint2 = referencePointX+25;
      yPoint2 = referencePointY+25;
      xPoint3 = referencePointX;
      yPoint3 = referencePointY-25;
      xPoint4 = referencePointX;
      yPoint4 = referencePointY+25;
      xPoint5 = referencePointX-25;
      yPoint5 = referencePointY;
      xPoint6 = referencePointX+25;
      yPoint6 = referencePointY;
    } else if (towerVersion==1){
      xPoint1 = referencePointX-25;
      yPoint1 = referencePointY-25;
      xPoint2 = referencePointX+25;
      yPoint2 = referencePointY+25;
      xPoint3 = referencePointX-25;
      yPoint3 = referencePointY-25;
      xPoint4 = referencePointX+25;
      yPoint4 = referencePointY+25;
      xPoint5 = referencePointX-25;
      yPoint5 = referencePointY+25;
      xPoint6 = referencePointX+25;
      yPoint6 = referencePointY-25;
    } else if (towerVersion==2){
      xPoint1 = referencePointX;
      yPoint1 = referencePointY-25;
      xPoint2 = referencePointX-25;
      yPoint2 = referencePointY;
      xPoint3 = referencePointX;
      yPoint3 = referencePointY+25;
      xPoint4 = referencePointX+25;
      yPoint4 = referencePointY;
    } else if (towerVersion==3){
      xPoint1 = referencePointX-25;
      yPoint1 = referencePointY-25;
      xPoint2 = referencePointX+25;
      yPoint2 = referencePointY+25;
      xPoint3 = referencePointX;
      yPoint3 = referencePointY-25;
      xPoint4 = referencePointX-25;
      yPoint4 = referencePointY;
      xPoint5 = referencePointX;
      yPoint5 = referencePointY+25;
      xPoint6 = referencePointX+25;
      yPoint6 = referencePointY;
    } else if (towerVersion==4){
      xPoint1 = referencePointX-25;
      yPoint1 = referencePointY-25;
      xPoint2 = referencePointX;
      yPoint2 = referencePointY;
      xPoint3 = referencePointX+25;
      yPoint3 = referencePointY+25;
    } else if (towerVersion==5){
      xPoint1 = referencePointX-25;
      yPoint1 = referencePointY-25;
      xPoint2 = referencePointX+25;
      yPoint2 = referencePointY+25;
    }
    xBounding1 = referencePointX-25;
    yBounding1 = referencePointY-25;
    xBounding2 = referencePointX+25;
    yBounding2 = referencePointY+25;
    lightTowerVersion=towerVersion;
    bulletDamage=2/60;
    firingRadius=100;
    enemyLockedOn=false;
    bulletLocation= new PVector(referencePointX,referencePointY);
  }
  
  void build(int towerVersion){
    for(int lineNumber=1;lineNumber<=4;lineNumber++){
      noFill();
      strokeWeight(strkWght-(2*(lineNumber-1)));
      stroke(lightTowerColour,((30*lineNumber)-glowFrame),99,((30*lineNumber)-glowFrame));
      if (towerVersion==0 || towerVersion==1){
        rect(xPoint1,yPoint1,xPoint2,yPoint2);
        line(xPoint3,yPoint3,xPoint4,yPoint4);
        line(xPoint5,yPoint5,xPoint6,yPoint6);
      } else if (towerVersion==2){
        line(xPoint1,yPoint1,xPoint2,yPoint2);
        line(xPoint2,yPoint2,xPoint3,yPoint3);
        line(xPoint3,yPoint3,xPoint4,yPoint4);
        line(xPoint4,yPoint4,xPoint1,yPoint1);
      } else if (towerVersion==3){
        rect(xPoint1,yPoint1,xPoint2,yPoint2);
        line(xPoint3,yPoint3,xPoint4,yPoint4);
        line(xPoint4,yPoint4,xPoint5,yPoint5);
        line(xPoint5,yPoint5,xPoint6,yPoint6);
        line(xPoint6,yPoint6,xPoint3,yPoint3);
      } else if (towerVersion==4){
        rect(xPoint1,yPoint1,xPoint2,yPoint2);
        rect(xPoint2,yPoint2,xPoint3,yPoint3);
      } else if (towerVersion==5){
        ellipse(xPoint1,yPoint1,xPoint2,yPoint2);
      }
    } 
  }
  
  void buildButton(int towerVersion){
    for(int lineNumber=1;lineNumber<=4;lineNumber++){
      noFill();
      strokeWeight(strkWght-(2*(lineNumber-1)));
      stroke(lightTowerColour,30*lineNumber,99,30*lineNumber);
      if (towerVersion==0 || towerVersion==1){
        rect(xPoint1,yPoint1,xPoint2,yPoint2);
        line(xPoint3,yPoint3,xPoint4,yPoint4);
        line(xPoint5,yPoint5,xPoint6,yPoint6);
      } else if (towerVersion==2){
        line(xPoint1,yPoint1,xPoint2,yPoint2);
        line(xPoint2,yPoint2,xPoint3,yPoint3);
        line(xPoint3,yPoint3,xPoint4,yPoint4);
        line(xPoint4,yPoint4,xPoint1,yPoint1);
      } else if (towerVersion==3){
        rect(xPoint1,yPoint1,xPoint2,yPoint2);
        line(xPoint3,yPoint3,xPoint4,yPoint4);
        line(xPoint4,yPoint4,xPoint5,yPoint5);
        line(xPoint5,yPoint5,xPoint6,yPoint6);
        line(xPoint6,yPoint6,xPoint3,yPoint3);
      } else if (towerVersion==4){
        rect(xPoint1,yPoint1,xPoint2,yPoint2);
        rect(xPoint2,yPoint2,xPoint3,yPoint3);
      } else if (towerVersion==5){
        ellipse(xPoint1,yPoint1,xPoint2,yPoint2);
      }
    } 
  }
  
  void constructTower(int towerVersion){
    if (isBoundToMouse){
      for(int lineNumber=1;lineNumber<=4;lineNumber++){
        noFill();
        strokeWeight(strkWght-(2*(lineNumber-1)));
        stroke(lightTowerColour,30*lineNumber,99,30*lineNumber);
        if (towerVersion==0){
          rect(mouseX-25,mouseY-25,mouseX+25,mouseY+25);
          line(mouseX,mouseY-25,mouseX,mouseY+25);
          line(mouseX-25,mouseY,mouseX+25,mouseY);
        } else if (towerVersion==1){
          rect(mouseX-25,mouseY-25,mouseX+25,mouseY+25);
          line(mouseX-25,mouseY-25,mouseX+25,mouseY+25);
          line(mouseX+25,mouseY-25,mouseX-25,mouseY+25);
        } else if (towerVersion==2){
          line(mouseX,mouseY-25,mouseX-25,mouseY);
          line(mouseX-25,mouseY,mouseX,mouseY+25);
          line(mouseX,mouseY+25,mouseX+25,mouseY);
          line(mouseX+25,mouseY,mouseX,mouseY-25);
        } else if (towerVersion==3){
          rect(mouseX-25,mouseY-25,mouseX+25,mouseY+25);
          line(mouseX,mouseY-25,mouseX-25,mouseY);
          line(mouseX-25,mouseY,mouseX,mouseY+25);
          line(mouseX,mouseY+25,mouseX+25,mouseY);
          line(mouseX+25,mouseY,mouseX,mouseY-25);
        } else if (towerVersion==4){
          rect(mouseX-25,mouseY-25,mouseX,mouseY);
          rect(mouseX,mouseY,mouseX+25,mouseY+25);
        } else if (towerVersion==5){
          ellipse(mouseX-25,mouseY-25,mouseX+25,mouseY+25);
        }
      }
    }
  }
  
  void shootEnemy(int enemyClass, int arrayPosition){
    strokeWeight(5);
    stroke(360);
    if (enemyClass==1){
      line(this.bulletLocation.x,this.bulletLocation.y,easyEnemies[arrayPosition].centerPoint.x,easyEnemies[arrayPosition].centerPoint.y);
    } else if (enemyClass==2){
      line(this.bulletLocation.x,this.bulletLocation.y,mediumEnemies[arrayPosition].centerPoint.x,mediumEnemies[arrayPosition].centerPoint.y);
    } else if (enemyClass==3){
      line(this.bulletLocation.x,this.bulletLocation.y,hardEnemies[arrayPosition].centerPoint.x,hardEnemies[arrayPosition].centerPoint.y);
    }
    this.enemyLockedOn=false;
  }
}