//This class handles everything about the Medium Enemy class.
//Has a method to draw the enemy and update the position of the enemy.

class MediumEnemy{
  float currentHealth;
  int mediumEnemyType;
  int mediumEnemyColour = 30;
  
  PVector centerPoint;
  float boundingDistanceX = 25/2;
  float boundingDistanceY = 50/2;
  int movementSpeed = 1;
  PVector moveRightLeft= new PVector(movementSpeed,0);
  PVector moveUpDown= new PVector(0,movementSpeed);
  boolean movingRight=false;
  boolean movingLeft=false;
  boolean movingUp=false;
  boolean movingDown=false;
  
  MediumEnemy(int enemyType){
    centerPoint= new PVector(75,375);
    currentHealth = 20;
    mediumEnemyType=enemyType;
  }
  
  void build(int enemyType){
    for(int lineNumber=1;lineNumber<=3;lineNumber++){
      noFill();
      strokeWeight((strkWght-2)-(2*(lineNumber-1)));
      stroke(mediumEnemyColour,((30*lineNumber)-glowFrame),99,((30*lineNumber)-glowFrame));
      if (enemyType==0){
        if(movingRight || movingLeft){
          rect(centerPoint.x-boundingDistanceX,centerPoint.y-boundingDistanceY,centerPoint.x+boundingDistanceX,centerPoint.y+boundingDistanceY);
          line(centerPoint.x-boundingDistanceX,centerPoint.y,centerPoint.x+boundingDistanceX,centerPoint.y);
        } else if (movingUp || movingDown){
          rect(centerPoint.x-boundingDistanceY,centerPoint.y-boundingDistanceX,centerPoint.x+boundingDistanceY,centerPoint.y+boundingDistanceX);
          line(centerPoint.x,centerPoint.y-boundingDistanceX,centerPoint.x,centerPoint.y+boundingDistanceX);
        }
      } else if (enemyType==1){
        if(movingRight || movingLeft){
          rect(centerPoint.x-boundingDistanceX,centerPoint.y-boundingDistanceY,centerPoint.x+boundingDistanceX,centerPoint.y+boundingDistanceY);
          line(centerPoint.x-boundingDistanceX,centerPoint.y-boundingDistanceY,centerPoint.x+boundingDistanceX,centerPoint.y);
          line(centerPoint.x-boundingDistanceX,centerPoint.y,centerPoint.x+boundingDistanceX,centerPoint.y-boundingDistanceY);
          line(centerPoint.x-boundingDistanceX,centerPoint.y,centerPoint.x+boundingDistanceX,centerPoint.y+boundingDistanceY);
          line(centerPoint.x-boundingDistanceX,centerPoint.y+boundingDistanceY,centerPoint.x+boundingDistanceX,centerPoint.y);
        } else if (movingUp || movingDown){
          rect(centerPoint.x-boundingDistanceY,centerPoint.y-boundingDistanceX,centerPoint.x+boundingDistanceY,centerPoint.y+boundingDistanceX);
          line(centerPoint.x-boundingDistanceY,centerPoint.y-boundingDistanceX,centerPoint.x,centerPoint.y+boundingDistanceX);
          line(centerPoint.x-boundingDistanceY,centerPoint.y+boundingDistanceX,centerPoint.x,centerPoint.y-boundingDistanceX);
          line(centerPoint.x,centerPoint.y-boundingDistanceX,centerPoint.x+boundingDistanceY,centerPoint.y+boundingDistanceX);
          line(centerPoint.x,centerPoint.y+boundingDistanceX,centerPoint.x+boundingDistanceY,centerPoint.y-boundingDistanceX);
        }
      } else if (enemyType==2){
        if(movingRight){
          triangle(centerPoint.x-boundingDistanceX,centerPoint.y-boundingDistanceY,centerPoint.x+boundingDistanceX,centerPoint.y,centerPoint.x-boundingDistanceX,centerPoint.y+boundingDistanceY);
        } else if (movingLeft){
          triangle(centerPoint.x+boundingDistanceX,centerPoint.y-boundingDistanceY,centerPoint.x-boundingDistanceX,centerPoint.y,centerPoint.x+boundingDistanceX,centerPoint.y+boundingDistanceY);
        } else if (movingUp){
          triangle(centerPoint.x-boundingDistanceY,centerPoint.y+boundingDistanceX,centerPoint.x,centerPoint.y-boundingDistanceX,centerPoint.x+boundingDistanceY,centerPoint.y+boundingDistanceX);
        } else if (movingDown){
          triangle(centerPoint.x-boundingDistanceY,centerPoint.y-boundingDistanceX,centerPoint.x,centerPoint.y+boundingDistanceX,centerPoint.x+boundingDistanceY,centerPoint.y-boundingDistanceX);
        }
      } else if (enemyType==3){
        if(movingRight){
          triangle(centerPoint.x-boundingDistanceX,centerPoint.y-boundingDistanceY,centerPoint.x+boundingDistanceX,centerPoint.y,centerPoint.x+boundingDistanceX,centerPoint.y-boundingDistanceY);
          triangle(centerPoint.x-boundingDistanceX,centerPoint.y+boundingDistanceY,centerPoint.x+boundingDistanceX,centerPoint.y,centerPoint.x+boundingDistanceX,centerPoint.y+boundingDistanceY);
        } else if (movingLeft){
          triangle(centerPoint.x-boundingDistanceX,centerPoint.y-boundingDistanceY,centerPoint.x-boundingDistanceX,centerPoint.y,centerPoint.x+boundingDistanceX,centerPoint.y-boundingDistanceY);
          triangle(centerPoint.x-boundingDistanceX,centerPoint.y+boundingDistanceY,centerPoint.x-boundingDistanceX,centerPoint.y,centerPoint.x+boundingDistanceX,centerPoint.y+boundingDistanceY);
        } else if (movingUp){
          triangle(centerPoint.x-boundingDistanceY,centerPoint.y-boundingDistanceX,centerPoint.x-boundingDistanceY,centerPoint.y+boundingDistanceX,centerPoint.x,centerPoint.y-boundingDistanceX);
          triangle(centerPoint.x+boundingDistanceY,centerPoint.y-boundingDistanceX,centerPoint.x+boundingDistanceY,centerPoint.y+boundingDistanceX,centerPoint.x,centerPoint.y-boundingDistanceX);
        } else if (movingDown){
          triangle(centerPoint.x-boundingDistanceY,centerPoint.y-boundingDistanceX,centerPoint.x-boundingDistanceY,centerPoint.y+boundingDistanceX,centerPoint.x,centerPoint.y+boundingDistanceX);
          triangle(centerPoint.x+boundingDistanceY,centerPoint.y-boundingDistanceX,centerPoint.x+boundingDistanceY,centerPoint.y+boundingDistanceX,centerPoint.x,centerPoint.y+boundingDistanceX);
        }
      } else if (enemyType==4){
        if (movingRight || movingLeft){
          ellipse(centerPoint.x-boundingDistanceX,centerPoint.y-boundingDistanceY,centerPoint.x+boundingDistanceX,centerPoint.y);
          ellipse(centerPoint.x-boundingDistanceX,centerPoint.y,centerPoint.x+boundingDistanceX,centerPoint.y+boundingDistanceY);
        } else if (movingUp || movingDown){
          ellipse(centerPoint.x-boundingDistanceY,centerPoint.y-boundingDistanceX,centerPoint.x,centerPoint.y+boundingDistanceX);
          ellipse(centerPoint.x,centerPoint.y-boundingDistanceX,centerPoint.x+boundingDistanceY,centerPoint.y+boundingDistanceX);
        }
      }
    }
  }
  
  void move(){
    if(centerPoint.x==75 && centerPoint.y==375){
      movingUp=false;
      movingDown=false;
      movingLeft=false;
      movingRight=true;
    }
    
    for(int pathwayCounter=0;pathwayCounter<pathwayCheckpointsX.length;pathwayCounter++){
      if (centerPoint.x==pathwayCheckpointsX[pathwayCounter] && centerPoint.y==pathwayCheckpointsY[pathwayCounter]){
        if (pathwayCounter==0 || pathwayCounter==2 || pathwayCounter==6 || pathwayCounter==8 || pathwayCounter==12){
          movingUp=true;
          movingDown=false;
          movingLeft=false;
          movingRight=false;
        } else if (pathwayCounter==4 || pathwayCounter==10){
          movingUp=false;
          movingDown=true;
          movingLeft=false;
          movingRight=false;
        } else if (pathwayCounter==1){
          movingUp=false;
          movingDown=false;
          movingLeft=true;
          movingRight=false;
        } else if (pathwayCounter==3 || pathwayCounter==5 || pathwayCounter==7 || pathwayCounter==9 || pathwayCounter==11){
          movingUp=false;
          movingDown=false;
          movingLeft=false;
          movingRight=true;
        } else if (pathwayCounter==13){
          movingUp=false;
          movingDown=false;
          movingLeft=false;
          movingRight=false;
        }
      }
    }
    
    if(movingRight){
      centerPoint.add(moveRightLeft);
    } else if (movingLeft){
      centerPoint.sub(moveRightLeft);
    } else if (movingUp){
      centerPoint.sub(moveUpDown);
    } else if (movingDown){
      centerPoint.add(moveUpDown);
    }
  }
}