/*************************************************************************************
Neon Tower Defence

Designed, Programmed and Tested by:
Kyle Budge
For additional notes or for rough sketches see attached pages.
 
Created as Assignment #3 (Object-Oriented Interactive Toy) for:
Nicolas Hesler
Introduction to Media Computation
 
Designed, programmed and tested with Processing v3.2.1
*************************************************************************************/

/*
Instructions:
1. Pick up towers by clicking on a button at the bottom of the screen.
  Each button is a seperate tower.
  The towers on the left are weak, the towers on the right are strong.
  Use SHIFT to return a tower to storage BEFORE placing it on the grid.
2. Place tower on the grid in desired location.
  Don't worry about overlapping anything, the game handles that.
3. Place as many towers as you want in as many locations as you want.
4. Press CONTROL when ready to start your first wave!
  While wave is running you can not place new towers.
5. When the wave is over you may place more towers and start a new wave.
*/

/*
Programmer Notes
A very ambitious project that is still a day or two away from complete implementation.
Things which were not included due to time constraints are health systems for enemies,
tower's causing actual damage, a limit to the number of towers that can be placed, and
a procedural difficulty system that adjusts as you play.
Most of this can be found in pieces through variables or functions.
As of now, the toy is designed to look pretty on the first wave.
*/

//Global Variables

//Grid Object Variables
Grid[] verticalGrid = new Grid[34];
Grid[] horizontalGrid = new Grid[26];
boolean initialGridRequired=true;

//Pathway Object Variables
int[] pathwayBoundaryX = {125,200,150,200,50,150,50,100,100,300,250,300,300,450,400,450,450,550,500,550,550,650,600,650,650,750,700,750};
int[] pathwayBoundaryY = {350,400,200,350,200,250,50,200,50,100,100,350,300,350,200,300,200,250,100,200,100,150,150,400,350,400,125,350};
int[] pathwayCheckpointsX = {175,175,75,75,275,275,425,425,525,525,625,625,725,725};
int[] pathwayCheckpointsY = {375,225,225,75,75,325,325,225,225,125,125,375,375,75};
Pathway[] enemyPathway = new Pathway[14];
boolean initialPathwayRequired=true;

//Start and End House Variables
House startHouse = new House(0);
House endHouse = new House(1);

//Tower Storage Box Variables
TowerStorageBox[] towerStorageBoxArray = new TowerStorageBox[3];
boolean initialTowerStorageBoxRequired=true;

//Tower Variables
LightTower[] lightTowers = new LightTower[0];
LightTower[] lightTowerButtons = new LightTower[6];
int lightTowerPressedButton;
MediumTower[] mediumTowers = new MediumTower[0];
MediumTower[] mediumTowerButtons = new MediumTower[6];
int mediumTowerPressedButton;
HeavyTower[] heavyTowers = new HeavyTower[0];
HeavyTower[] heavyTowerButtons = new HeavyTower[6];
int heavyTowerPressedButton;
char towerType;
boolean initialTowerButtonsRequired=true;

//Enemy Variables
EasyEnemy[] easyEnemies = new EasyEnemy[0];
int easyEnemiesDefeated=0;
MediumEnemy[] mediumEnemies = new MediumEnemy[0];
int mediumEnemiesDefeated=0;
HardEnemy[] hardEnemies = new HardEnemy[0];
int hardEnemiesDefeated=0;

int waveDifficulty=50;
int easyEnemiesToCreate=0;
int mediumEnemiesToCreate=0;
int hardEnemiesToCreate=0;
int startTimer=millis();
boolean creatingEnemies=false;
boolean timeToCreateEnemy=false;
boolean waveRunning=false;

//General Variables
boolean pulsing = false;
int glowFrame = 0;
int strkWght=7;
boolean mouseIsFree=true;

//Setting up basic requirements and modes for the program.
void setup(){
  size(800,600);
  frameRate(60);
  smooth(2);
  rectMode(CORNERS);
  ellipseMode(CORNERS);
  colorMode(HSB,360,100,100,100);
  println("Place towers by clicking on one of the buttons at the bottom of the screen.");
  println("Place the tower anywhere on the grid, place as many towers as you like!");
  println("Use SHIFT to return a tower to storage before placing on the grid");
  println("Press CONTROL when you've placed enough towers to start the wave of enemies!");
}

//Run the entire program through main functions which call and build all the objects.
//All functions run "on initialization" for the first time using a boolean.
//This populates all the arrays while the funtion then keeps drawing everything on subsequent passes.
void draw(){
  background(262,66,36,100);
  glowAnimation();
  constructGrid();
  constructPathway();
  drawEnemies();
  startHouse.build();
  endHouse.build();
  constructTowerStorageBox();
  constructTowerButtons();
  constructTowers();
  buildAllTowers();
  allTowersAttack();
  
}

//Simple function to create a glow variable used when drawing all the objects.
void glowAnimation(){
  if(!pulsing){
    if (glowFrame<30){
      glowFrame++;
    } else if (glowFrame>=30){
      pulsing=true;
    }
  } else if(pulsing){
    if(glowFrame>0){
      glowFrame--;
    } else if(glowFrame<=0){
      pulsing=false;
    }
  }  
}

//Function that uses loops to create all of the grid lines in the background.
void constructGrid(){
  if (initialGridRequired){
    for (int lineCounter = 1;lineCounter<verticalGrid.length;lineCounter++){
      if (lineCounter<=horizontalGrid.length){
        verticalGrid[lineCounter-1]=new Grid(0,lineCounter);
        horizontalGrid[lineCounter-1]=new Grid(1,lineCounter);
      } else {
         verticalGrid[lineCounter-1]=new Grid(0,lineCounter);
      }
    }
    initialGridRequired=false;
  } else {
    for (int gridConstructor=0;gridConstructor<verticalGrid.length-1;gridConstructor++){
      if (gridConstructor<horizontalGrid.length-1){
      verticalGrid[gridConstructor].construct();
      horizontalGrid[gridConstructor].construct();
    } else {
      verticalGrid[gridConstructor].construct();
      }
    }
  }
}

//Function to create all of the pathway using smaller rectangles.
void constructPathway(){
  if (initialPathwayRequired){
    for (int pathwayCounter=0;pathwayCounter<pathwayBoundaryX.length;pathwayCounter+=2){
      enemyPathway[pathwayCounter/2]=new Pathway(pathwayCounter);
    }
    initialPathwayRequired=false;
  } else {
    for (int pathwayCounter=0;pathwayCounter<enemyPathway.length;pathwayCounter++){
      enemyPathway[pathwayCounter].build();
    }
  }
}

//Creates the boxes at the bottom of the screen to house to tower buttons.
//Does NOT create tower buttons.
void constructTowerStorageBox(){
  if (initialTowerStorageBoxRequired){
    for(int towerStorageBoxCounter=0;towerStorageBoxCounter<towerStorageBoxArray.length;towerStorageBoxCounter++){
      towerStorageBoxArray[towerStorageBoxCounter]=new TowerStorageBox(towerStorageBoxCounter);
    }
    initialTowerStorageBoxRequired=false;
  } else {
    for(int towerStorageBoxCounter=0;towerStorageBoxCounter<towerStorageBoxArray.length;towerStorageBoxCounter++){
      towerStorageBoxArray[towerStorageBoxCounter].build();
    }
  }
}

//Creates all of the buttons used to create the towers.
//Buttons are all scaled to be 50px by 50px instead of the usual tower size.
void constructTowerButtons(){
  if (initialTowerButtonsRequired){
    for (int towerButtonCounter=0;towerButtonCounter<lightTowerButtons.length;towerButtonCounter++){
      if (towerButtonCounter<=2){
        lightTowerButtons[towerButtonCounter] = new LightTower(towerButtonCounter,55+(80*towerButtonCounter),495);
        mediumTowerButtons[towerButtonCounter] = new MediumTower(towerButtonCounter,330+(80*towerButtonCounter),505);
        heavyTowerButtons[towerButtonCounter] = new HeavyTower(towerButtonCounter,580+(80*towerButtonCounter),495);
      } else {
        lightTowerButtons[towerButtonCounter] = new LightTower(towerButtonCounter,55+(80*(towerButtonCounter-3)),565);
        mediumTowerButtons[towerButtonCounter] = new MediumTower(towerButtonCounter,330+(80*(towerButtonCounter-3)),575);
        heavyTowerButtons[towerButtonCounter] = new HeavyTower(towerButtonCounter,580+(80*(towerButtonCounter-3)),565);
      }
    }
    initialTowerButtonsRequired=false;
  } else {
    for (int towerButtonCounter=0;towerButtonCounter<lightTowerButtons.length;towerButtonCounter++){
      lightTowerButtons[towerButtonCounter].buildButton(towerButtonCounter);
      mediumTowerButtons[towerButtonCounter].buildButton(towerButtonCounter);
      heavyTowerButtons[towerButtonCounter].buildButton(towerButtonCounter);
    }
  }
}

//This function is used by the buttons to actually create a tower when clicking on a button.
//Checks to see which button is pressed and creates a tower accordingly at regular size.
//Tower is erased and recreated in the array at the correct location to get the placement variables correct.
void constructTowers(){
  int placementXPosition=0;
  int placementYPosition=0;
  if (mouseIsFree){
    for (int towerButtonPressed=0;towerButtonPressed<lightTowerButtons.length;towerButtonPressed++){
      if (mousePressed && !waveRunning &&
          mouseX>=lightTowerButtons[towerButtonPressed].xBounding1 && mouseX<=lightTowerButtons[towerButtonPressed].xBounding2 && 
          mouseY>=lightTowerButtons[towerButtonPressed].yBounding1 && mouseY<=lightTowerButtons[towerButtonPressed].yBounding2){
        mouseIsFree=false;
        lightTowers = (LightTower[])append(lightTowers,new LightTower(towerButtonPressed,-100,-100));
        lightTowers[lightTowers.length-1].isBoundToMouse = true;
        lightTowerPressedButton=towerButtonPressed;
        towerType='l';
      }
      if (mousePressed && !waveRunning &&
          mouseX>=mediumTowerButtons[towerButtonPressed].buttonXBounding1 && mouseX<=mediumTowerButtons[towerButtonPressed].buttonXBounding2 && 
          mouseY>=mediumTowerButtons[towerButtonPressed].buttonYBounding1 && mouseY<=mediumTowerButtons[towerButtonPressed].buttonYBounding2){
        mouseIsFree=false;
        mediumTowers = (MediumTower[])append(mediumTowers,new MediumTower(towerButtonPressed,-100,-100));
        mediumTowers[mediumTowers.length-1].isBoundToMouse = true;
        mediumTowerPressedButton=towerButtonPressed;
        towerType='m';
      }
      if (mousePressed && !waveRunning &&
          mouseX>=heavyTowerButtons[towerButtonPressed].buttonXBounding1 && mouseX<=heavyTowerButtons[towerButtonPressed].buttonXBounding2 && 
          mouseY>=heavyTowerButtons[towerButtonPressed].buttonYBounding1 && mouseY<=heavyTowerButtons[towerButtonPressed].buttonYBounding2){
        mouseIsFree=false;
        heavyTowers = (HeavyTower[])append(heavyTowers,new HeavyTower(towerButtonPressed,-100,-100));
        heavyTowers[heavyTowers.length-1].isBoundToMouse = true;
        heavyTowerPressedButton=towerButtonPressed;
        towerType='h';
      }
    }
    //This little section binds everything to the grid correctly.
    //No matter where you wish to place the tower it will always snap to the closest grid location.
  } else if (!mouseIsFree) {
    if (mouseX%25<=12){
      placementXPosition=mouseX-(mouseX%25);
    } else {
      placementXPosition=mouseX+(25-(mouseX%25));
    }
    if (mouseY%25<=12){
      placementYPosition=mouseY-(mouseY%25);
    } else {
      placementYPosition=mouseY+(25-(mouseY%25));
    }
    //You will notice a call to a boolean function in here "isIntersecting", this will be explained in more detail at that function.
    //This call is to ensure that you aren't trying to place your tower over any other object.
    if(towerType=='l'){
      lightTowers[lightTowers.length-1].constructTower(lightTowerPressedButton);
      if (lightTowers[lightTowers.length-1].isBoundToMouse==true && mousePressed && !isInterecting(towerType,placementXPosition,placementYPosition)){
        mouseIsFree=true;
        lightTowers[lightTowers.length-1].isBoundToMouse=false;
        lightTowers[lightTowers.length-1] = new LightTower(lightTowerPressedButton,placementXPosition,placementYPosition);
      }
    }
    if(towerType=='m'){
      mediumTowers[mediumTowers.length-1].constructTower(mediumTowerPressedButton);
      if (mediumTowers[mediumTowers.length-1].isBoundToMouse==true && mousePressed && !isInterecting(towerType,placementXPosition,placementYPosition)){
        mouseIsFree=true;
        mediumTowers[mediumTowers.length-1].isBoundToMouse=false;
        mediumTowers[mediumTowers.length-1] = new MediumTower(mediumTowerPressedButton,placementXPosition,placementYPosition);
      }
    }
    if(towerType=='h'){
      heavyTowers[heavyTowers.length-1].constructTower(heavyTowerPressedButton);
      if (heavyTowers[heavyTowers.length-1].isBoundToMouse==true && mousePressed && !isInterecting(towerType,placementXPosition,placementYPosition)){
        mouseIsFree=true;
        heavyTowers[heavyTowers.length-1].isBoundToMouse=false;
        heavyTowers[heavyTowers.length-1] = new HeavyTower(heavyTowerPressedButton,placementXPosition,placementYPosition);
      }
    }
    //This "drops" your tower that you are holding back into storage, in case you want to pick a different tower.
    if (keyPressed && keyCode==SHIFT){
      mouseIsFree=true;
      if (towerType=='l'){
        lightTowers = (LightTower[])shorten(lightTowers);
      }
      if (towerType=='m'){
        mediumTowers = (MediumTower[])shorten(mediumTowers);
      }
      if (towerType=='h'){
        heavyTowers = (HeavyTower[])shorten(heavyTowers);
      }
    }
  }
}


//Function that scrolls through all of the tower arrays and draws the objects to the screen in the correct locations.
void buildAllTowers(){
  for (int towerNumber=0;towerNumber<lightTowers.length;towerNumber++){
    lightTowers[towerNumber].build(lightTowers[towerNumber].lightTowerVersion);
  }
  for (int towerNumber=0;towerNumber<mediumTowers.length;towerNumber++){
    mediumTowers[towerNumber].build(mediumTowers[towerNumber].mediumTowerVersion);
  }
  for (int towerNumber=0;towerNumber<heavyTowers.length;towerNumber++){
    heavyTowers[towerNumber].build(heavyTowers[towerNumber].heavyTowerVersion);
  }
}


//This function is multi-layered.
//First it scrolls through all of the tower arrays and all of the created enemy arrays.
//It compares the distance between the vectors for all of the objects and decides which objects are "within range".
//Enemies within range of the tower are shot at.
//When the towers shoot function is called it's passed the details of the enemy it is firing at to make sure it's using the right information.
void allTowersAttack(){
  //This runs the check for all the light towers.
  if(lightTowers.length>0){
    int enemyClass=0;
    int arrayPosition=0;
    for (int enemyFinderTower=0;enemyFinderTower<lightTowers.length;enemyFinderTower++){
      if (!lightTowers[enemyFinderTower].enemyLockedOn){
        for (int enemyFinderEnemy=0;enemyFinderEnemy<easyEnemies.length;enemyFinderEnemy++){
          if (lightTowers[enemyFinderTower].bulletLocation.dist(easyEnemies[enemyFinderEnemy].centerPoint)<lightTowers[enemyFinderTower].firingRadius){
            enemyClass=1;
            arrayPosition=enemyFinderEnemy;
            lightTowers[enemyFinderTower].enemyLockedOn=true;
          }
        }
        for (int enemyFinderEnemy=0;enemyFinderEnemy<mediumEnemies.length;enemyFinderEnemy++){
          if (lightTowers[enemyFinderTower].bulletLocation.dist(mediumEnemies[enemyFinderEnemy].centerPoint)<lightTowers[enemyFinderTower].firingRadius){
            enemyClass=2;
            arrayPosition=enemyFinderEnemy;
            lightTowers[enemyFinderTower].enemyLockedOn=true;
          }
        }
        for (int enemyFinderEnemy=0;enemyFinderEnemy<hardEnemies.length;enemyFinderEnemy++){
          if (lightTowers[enemyFinderTower].bulletLocation.dist(hardEnemies[enemyFinderEnemy].centerPoint)<lightTowers[enemyFinderTower].firingRadius){
            enemyClass=3;
            arrayPosition=enemyFinderEnemy;
            lightTowers[enemyFinderTower].enemyLockedOn=true;
          }
        }
      }
      if (lightTowers[enemyFinderTower].enemyLockedOn){
        lightTowers[enemyFinderTower].shootEnemy(enemyClass,arrayPosition);
      }
    }
  }
  //This runs the check for all the medium towers.
  if(mediumTowers.length>0){
    int enemyClass=0;
    int arrayPosition=0;
    for (int enemyFinderTower=0;enemyFinderTower<mediumTowers.length;enemyFinderTower++){
      if (!mediumTowers[enemyFinderTower].enemyLockedOn){
        for (int enemyFinderEnemy=0;enemyFinderEnemy<easyEnemies.length;enemyFinderEnemy++){
          if (mediumTowers[enemyFinderTower].bulletLocation.dist(easyEnemies[enemyFinderEnemy].centerPoint)<mediumTowers[enemyFinderTower].firingRadius){
            enemyClass=1;
            arrayPosition=enemyFinderEnemy;
            mediumTowers[enemyFinderTower].enemyLockedOn=true;
          }
        }
        for (int enemyFinderEnemy=0;enemyFinderEnemy<mediumEnemies.length;enemyFinderEnemy++){
          if (mediumTowers[enemyFinderTower].bulletLocation.dist(mediumEnemies[enemyFinderEnemy].centerPoint)<mediumTowers[enemyFinderTower].firingRadius){
            enemyClass=2;
            arrayPosition=enemyFinderEnemy;
            mediumTowers[enemyFinderTower].enemyLockedOn=true;
          }
        }
        for (int enemyFinderEnemy=0;enemyFinderEnemy<hardEnemies.length;enemyFinderEnemy++){
          if (mediumTowers[enemyFinderTower].bulletLocation.dist(hardEnemies[enemyFinderEnemy].centerPoint)<mediumTowers[enemyFinderTower].firingRadius){
            enemyClass=3;
            arrayPosition=enemyFinderEnemy;
            mediumTowers[enemyFinderTower].enemyLockedOn=true;
          }
        }
      }
      if (mediumTowers[enemyFinderTower].enemyLockedOn){
        mediumTowers[enemyFinderTower].shootEnemy(enemyClass,arrayPosition);
      }
    }
  }
  //This runs the check for all the heavy towers.
  if(heavyTowers.length>0){
    int enemyClass=0;
    int arrayPosition=0;
    for (int enemyFinderTower=0;enemyFinderTower<heavyTowers.length;enemyFinderTower++){
      if (!heavyTowers[enemyFinderTower].enemyLockedOn){
        for (int enemyFinderEnemy=0;enemyFinderEnemy<easyEnemies.length;enemyFinderEnemy++){
          if (heavyTowers[enemyFinderTower].bulletLocation.dist(easyEnemies[enemyFinderEnemy].centerPoint)<heavyTowers[enemyFinderTower].firingRadius){
            enemyClass=1;
            arrayPosition=enemyFinderEnemy;
            heavyTowers[enemyFinderTower].enemyLockedOn=true;
          }
        }
        for (int enemyFinderEnemy=0;enemyFinderEnemy<mediumEnemies.length;enemyFinderEnemy++){
          if (heavyTowers[enemyFinderTower].bulletLocation.dist(mediumEnemies[enemyFinderEnemy].centerPoint)<heavyTowers[enemyFinderTower].firingRadius){
            enemyClass=2;
            arrayPosition=enemyFinderEnemy;
            heavyTowers[enemyFinderTower].enemyLockedOn=true;
          }
        }
        for (int enemyFinderEnemy=0;enemyFinderEnemy<hardEnemies.length;enemyFinderEnemy++){
          if (heavyTowers[enemyFinderTower].bulletLocation.dist(hardEnemies[enemyFinderEnemy].centerPoint)<heavyTowers[enemyFinderTower].firingRadius){
            enemyClass=3;
            arrayPosition=enemyFinderEnemy;
            heavyTowers[enemyFinderTower].enemyLockedOn=true;
          }
        }
      }
      if (heavyTowers[enemyFinderTower].enemyLockedOn){
        heavyTowers[enemyFinderTower].shootEnemy(enemyClass,arrayPosition);
      }
    }
  }
}

//First this function checks to see if you want to start running the wave of enemies by pressing CONTROL.
//Then the function creates a new enemy based on a set of parameters in each of the enemy classes (easy, medium, hard).
//Once all the enemies are created it keeps them moving through the pathway towards the end.
void drawEnemies(){
  //This section starts the enemies flowing.
  if (keyPressed && keyCode==CONTROL && !waveRunning){
    creatingEnemies=true;
    waveRunning=true;
    easyEnemiesToCreate=waveDifficulty/2;
    mediumEnemiesToCreate=waveDifficulty/5;
    hardEnemiesToCreate=waveDifficulty/10;
  }
  //This is a mini timer to make sure enemies don't spawn all at once on top of each other
  if (creatingEnemies){
    if (millis()-startTimer>=1000 && !timeToCreateEnemy){
      timeToCreateEnemy=true;
      startTimer=millis();
    }
    if (timeToCreateEnemy){
      timeToCreateEnemy=false;
      if (hardEnemiesToCreate>0 && mediumEnemiesToCreate==0 && easyEnemiesToCreate==0 ){
        hardEnemies = (HardEnemy[])append(hardEnemies,new HardEnemy(floor(random(0,3))));
        hardEnemiesToCreate--;
      }
      if (mediumEnemiesToCreate>0 && easyEnemiesToCreate==0){
        mediumEnemies = (MediumEnemy[])append(mediumEnemies,new MediumEnemy(floor(random(0,4))));
        mediumEnemiesToCreate--;
      }
      if (easyEnemiesToCreate>0){
        easyEnemies = (EasyEnemy[])append(easyEnemies,new EasyEnemy(floor(random(0,6))));
        easyEnemiesToCreate--;
      }
      if (easyEnemiesToCreate==0 && mediumEnemiesToCreate==0 && hardEnemiesToCreate==0){
        creatingEnemies=false;
      }
    }
  }
  if (waveRunning){
    //Drawing all of the enemies for each enemy class, if they hit the end they are removed from the window until every enemy reaches the end.
    if (easyEnemies.length>0){
      for (int easyEnemyNumber=0;easyEnemyNumber<easyEnemies.length;easyEnemyNumber++){
        easyEnemies[easyEnemyNumber].move();
        easyEnemies[easyEnemyNumber].build(easyEnemies[easyEnemyNumber].easyEnemyType);
        if (easyEnemies[easyEnemyNumber].centerPoint.x==pathwayCheckpointsX[13] && easyEnemies[easyEnemyNumber].centerPoint.y==pathwayCheckpointsY[13]){
          easyEnemies[easyEnemyNumber].centerPoint.x=-200;
          easyEnemies[easyEnemyNumber].centerPoint.y=-200;
          easyEnemiesDefeated++;
          if (waveDifficulty>1){
            waveDifficulty--;
          }
          if (easyEnemiesDefeated==easyEnemies.length){
            easyEnemies = new EasyEnemy[0];
          }
        }
      }
    }
    if (mediumEnemies.length>0){
      for (int mediumEnemyNumber=0;mediumEnemyNumber<mediumEnemies.length;mediumEnemyNumber++){
        mediumEnemies[mediumEnemyNumber].move();
        mediumEnemies[mediumEnemyNumber].build(mediumEnemies[mediumEnemyNumber].mediumEnemyType);
        if (mediumEnemies[mediumEnemyNumber].centerPoint.x==pathwayCheckpointsX[13] && mediumEnemies[mediumEnemyNumber].centerPoint.y==pathwayCheckpointsY[13]){
          mediumEnemies[mediumEnemyNumber].centerPoint.x=-200;
          mediumEnemies[mediumEnemyNumber].centerPoint.y=-200;
          mediumEnemiesDefeated++;
          if (waveDifficulty>2){
            waveDifficulty-=2;
          }
          if (mediumEnemiesDefeated==mediumEnemies.length){
            mediumEnemies = new MediumEnemy[0];
          }
        }
      }
    }
    if (hardEnemies.length>0){
      for (int hardEnemyNumber=0;hardEnemyNumber<hardEnemies.length;hardEnemyNumber++){
        hardEnemies[hardEnemyNumber].move();
        hardEnemies[hardEnemyNumber].build(hardEnemies[hardEnemyNumber].hardEnemyType);
        if (hardEnemies[hardEnemyNumber].centerPoint.x==pathwayCheckpointsX[13] && hardEnemies[hardEnemyNumber].centerPoint.y==pathwayCheckpointsY[13]){
          hardEnemies[hardEnemyNumber].centerPoint.x=-200;
          hardEnemies[hardEnemyNumber].centerPoint.y=-200;
          hardEnemiesDefeated++;
          if (waveDifficulty>3){
            waveDifficulty-=3;
          }
          if (hardEnemiesDefeated==hardEnemies.length){
            hardEnemies = new HardEnemy[0];
          }
        }
      }
    }
  }  
  
  if (easyEnemies.length==0 && mediumEnemies.length==0 && hardEnemies.length==0){
    waveRunning=false;
  }
}


//This function is only ever when placing a tower.
//Checks to make sure you can't place your tower on any other object.
//Cycles through all objects in all arrays to ensure accuracy.
//Even if more objects are added the function handles the new array sizes properly.
boolean isInterecting(char towerType, int currentX, int currentY){
  int upperLeftX = 0, upperLeftY = 0, lowerRightX = 0, lowerRightY = 0;
  //This section lets you place the tower so the corner can overlap in some spots.
  //Makes it so you don't have to leave a full square empty between objects.
  switch(towerType){
    case 'l':
      upperLeftX = currentX-24;
      upperLeftY = currentY-24;
      lowerRightX = currentX+24;
      lowerRightY = currentY+24;
      break;
    case 'm':
      upperLeftX = currentX-49;
      upperLeftY = currentY-49;
      lowerRightX = currentX+24;
      lowerRightY = currentY+24;
      break;
    case 'h':
      upperLeftX = currentX-49;
      upperLeftY = currentY-49;
      lowerRightX = currentX+49;
      lowerRightY = currentY+49;
      break;
  }
  //Checks intersections for all possible light towers.
  for (int towerCounter=0;towerCounter<lightTowers.length;towerCounter++){
    if (upperLeftX>=lightTowers[towerCounter].xBounding1 && upperLeftX<=lightTowers[towerCounter].xBounding2 && 
        upperLeftY>=lightTowers[towerCounter].yBounding1 && upperLeftY<=lightTowers[towerCounter].yBounding2){
      return true;
    }
    if (lowerRightX>=lightTowers[towerCounter].xBounding1 && lowerRightX<=lightTowers[towerCounter].xBounding2 && 
        lowerRightY>=lightTowers[towerCounter].yBounding1 && lowerRightY<=lightTowers[towerCounter].yBounding2){
      return true;
    }
    if (currentX>=lightTowers[towerCounter].xBounding1 && currentX<=lightTowers[towerCounter].xBounding2 && 
        currentY>=lightTowers[towerCounter].yBounding1 && currentY<=lightTowers[towerCounter].yBounding2){
      return true;
    }
  }
  //Checks intersections for all possible medium towers.
  for (int towerCounter=0;towerCounter<mediumTowers.length;towerCounter++){
    if (upperLeftX>=mediumTowers[towerCounter].xBounding1 && upperLeftX<=mediumTowers[towerCounter].xBounding2 && 
        upperLeftY>=mediumTowers[towerCounter].yBounding1 && upperLeftY<=mediumTowers[towerCounter].yBounding2){
      return true;
    }
    if (lowerRightX>=mediumTowers[towerCounter].xBounding1 && lowerRightX<=mediumTowers[towerCounter].xBounding2 && 
        lowerRightY>=mediumTowers[towerCounter].yBounding1 && lowerRightY<=mediumTowers[towerCounter].yBounding2){
      return true;
    }
    if (currentX>=mediumTowers[towerCounter].xBounding1 && currentX<=mediumTowers[towerCounter].xBounding2 && 
        currentY>=mediumTowers[towerCounter].yBounding1 && currentY<=mediumTowers[towerCounter].yBounding2){
      return true;
    }
  }
  //Checks intersections for all possible heavy towers.
  for (int towerCounter=0;towerCounter<heavyTowers.length;towerCounter++){
    if (upperLeftX>=heavyTowers[towerCounter].xBounding1 && upperLeftX<=heavyTowers[towerCounter].xBounding2 && 
        upperLeftY>=heavyTowers[towerCounter].yBounding1 && upperLeftY<=heavyTowers[towerCounter].yBounding2){
      return true;
    }
    if (lowerRightX>=heavyTowers[towerCounter].xBounding1 && lowerRightX<=heavyTowers[towerCounter].xBounding2 && 
        lowerRightY>=heavyTowers[towerCounter].yBounding1 && lowerRightY<=heavyTowers[towerCounter].yBounding2){
      return true;
    }
    if (currentX>=heavyTowers[towerCounter].xBounding1 && currentX<=heavyTowers[towerCounter].xBounding2 && 
        currentY>=heavyTowers[towerCounter].yBounding1 && currentY<=heavyTowers[towerCounter].yBounding2){
      return true;
    }
  }
  
  //Checks intersections will all sections of the entire pathway.
  for (int pathwayCounter=0;pathwayCounter<enemyPathway.length;pathwayCounter++){
    if (upperLeftX>=enemyPathway[pathwayCounter].startingX && upperLeftX<=enemyPathway[pathwayCounter].endingX &&
        upperLeftY>=enemyPathway[pathwayCounter].startingY && upperLeftY<=enemyPathway[pathwayCounter].endingY){
      return true;
    }
    if (lowerRightX>=enemyPathway[pathwayCounter].startingX && lowerRightX<=enemyPathway[pathwayCounter].endingX &&
        lowerRightY>=enemyPathway[pathwayCounter].startingY && lowerRightY<=enemyPathway[pathwayCounter].endingY){
      return true;
    }
    if (currentX>=enemyPathway[pathwayCounter].startingX && currentX<=enemyPathway[pathwayCounter].endingX &&
        currentY>=enemyPathway[pathwayCounter].startingY && currentY<=enemyPathway[pathwayCounter].endingY){
      return true;
    }
  }
  
  //Checks intersections with all of the tower storage boxes.
  for (int towerStorageBoxCounter=0;towerStorageBoxCounter<towerStorageBoxArray.length;towerStorageBoxCounter++){
    if (upperLeftX>=towerStorageBoxArray[towerStorageBoxCounter].startingX && upperLeftX<=towerStorageBoxArray[towerStorageBoxCounter].endingX &&
        upperLeftY>=towerStorageBoxArray[towerStorageBoxCounter].startingY && upperLeftY<=towerStorageBoxArray[towerStorageBoxCounter].endingY){
      return true;
    }
    if (lowerRightX>=towerStorageBoxArray[towerStorageBoxCounter].startingX && lowerRightX<=towerStorageBoxArray[towerStorageBoxCounter].endingX &&
        lowerRightY>=towerStorageBoxArray[towerStorageBoxCounter].startingY && lowerRightY<=towerStorageBoxArray[towerStorageBoxCounter].endingY){
      return true;
    }
    if (currentX>=towerStorageBoxArray[towerStorageBoxCounter].startingX && currentX<=towerStorageBoxArray[towerStorageBoxCounter].endingX &&
        currentY>=towerStorageBoxArray[towerStorageBoxCounter].startingY && currentY<=towerStorageBoxArray[towerStorageBoxCounter].endingY){
      return true;
    }
  }
  
  //Checks intersections with the start and end zones.
  if (upperLeftX>=startHouse.startingX && upperLeftX<=startHouse.endingX &&
      upperLeftY>=startHouse.startingY && upperLeftY<=startHouse.endingY){
    return true; 
  }
  if (lowerRightX>=startHouse.startingX && lowerRightX<=startHouse.endingX &&
      lowerRightY>=startHouse.startingY && lowerRightY<=startHouse.endingY){
    return true;
  }
  if (currentX>=startHouse.startingX && currentX<=startHouse.endingX &&
      currentY>=startHouse.startingY && currentY<=startHouse.endingY){
    return true;
  }
  
  if (upperLeftX>=endHouse.startingX && upperLeftX<=endHouse.endingX &&
      upperLeftY>=endHouse.startingY && upperLeftY<=endHouse.endingY){
    return true;
  }
  if (lowerRightX>=endHouse.startingX && lowerRightX<=endHouse.endingX &&
      lowerRightY>=endHouse.startingY && lowerRightY<=endHouse.endingY){
    return true;
  }
  if (currentX>=endHouse.startingX && currentX<=endHouse.endingX &&
      currentY>=endHouse.startingY && currentY<=endHouse.endingY){
    return true;
  }
  
  //Checks to make sure the entire tower is still within the window frame.
  if (currentX==250 || currentX==500 || currentX==775){
    if (currentY==450){
      return true;
    }
  }
  if (currentX>775 || currentX<=10){
    return true;
  }
  if (currentY<=10 || currentY>=600){
    return true;
  }
  return false;
}