class Base {
  
  int colorVariation = 0; //variable for animating base lights
  int variationIncrement = 2; //controls the incrementation of the color shift
  
  Base() {
    init();
  }
  
  void init() {
  }
  
  void update() {
  }
  
  void display() {
    
    //draw the base itself
    
    noStroke();
    rectMode(CORNERS);
    fill(150,150,150,255);
    rect(baseLeft, baseTop, baseRight, baseBottom);
    
    //draw the base's lights
    
    ellipseMode(RADIUS);
    fill(128 + colorVariation,0,0);
    ellipse(80,550,5,5);
    ellipse(160,550,5,5);
    ellipse(240,550,5,5);
    ellipse(320,550,5,5);
    ellipse(400,550,5,5);
    ellipse(480,550,5,5);
    ellipse(560,550,5,5);
    ellipse(640,550,5,5);
    ellipse(720,550,5,5);
    
    //control the light "animation"
    
    colorVariation = colorVariation + variationIncrement;
    if (colorVariation > 50) {
      variationIncrement = -2;
    }
    if (colorVariation < -50) {
      variationIncrement = 2;
    }
    
    //draw the base's health bar
    
    fill(255,0,0);
    rect(275,565,525,585);
    fill(0,255,0);
    rect(275,565,275 + baseHealth / 2,585);
  }
}